#include "planegeometry.h"
#include <math.h>

int main(int argc, char *argv[])
{
	POINT P0, P, Q, F;
	LINE l;
	double t;

	P0.x = 2, P0.y = 0.;
	for(t = 0.02; t < 2. * M_PI; t += 0.02) {
		P.x = 2. * cos(t), P.y = sin(t);
		WRITE(P0, P);
		P0 = P;
	}
	if(argc > 2) {
		F.x = atof(argv[1]); F.y = atof(argv[2]);
	}
	else {
		F.x = 0., F.y = -1.;
	}
	printf("disk %f %f 0.05\n", F.x, F.y);
	printf("color 0 0 3\n");
	for(t = 0.; t < 2. * M_PI; t += 0.02) {
		l.a = cos(t); l.b = 2. * sin(t); l.c = -2.;
		//WRITE(l);
		Q = (F | l) * l;
		printf("disk %f %f 0.02\n", Q.x, Q.y);
	}
	return 0;
}
