#include "hbg.h"
#include <math.h>

Pl ctofsm(Pc c1, Pc c2, int s);

Pl ctofsm2(Pc c1, int s)
{
	Pl m;
	double e1, f1, n1, n;

	e1 = exp(c1.r);
	if((n =  c1.l | c1.l) > 0) {
		f1 = 0.5 * (e1 + 1. / e1);
		n1 = sqrt(n);
	}
	else {
		f1 = 0.5 * (e1 - 1. / e1);
		n1 = sqrt(-n);;
	}
	m.a = 2 * c1.l.a;
	m.b = 2 * c1.l.b + 2 * s * n1 * f1;
	m.c = 2 * c1.l.c + s * n1 * f1;
	return m;
}

int main()
{
	Pl m[4], n[3];
	Pc c[2];
	int i;

	for(i = 0; i < 2; i++) READ(c + i);
	printf("gray .6\ncircle 0 0 1\n");
	for(i = 0; i < 2; i++) WRITE(c[i].l);
	printf("gray 0\ncircle 0 -0.5 0.5\n");
	for(i = 0; i < 2; i++) WRITE(c[i]);
	printf("color 3 0 0\n");
	WRITE(m[2] = ctofsm(c[0], c[1], 1));
	for(i = 0; i < 2; i++) WRITE(m[i] = ctofsm2(c[i], 1));
	m[3] = m[0];
	WRITE(n[2] = ctofsm(c[0], c[1], -1));
	for(i = 0; i < 2; i++) WRITE(n[i] = ctofsm2(c[i], -1));
	printf("color 3 2 0\n");
	for(i = 0; i < 3; i++) WRITE(m[i] * m[i + 1]);
	WRITE(n[0] * n[1]);
	printf("color 0 3 1\n");
	for(i = 0; i < 2; i++) dtangents(m[i], c[i]);
	dtangents(m[2], c[0]);	
	printf("color 0 1 3\n");
	for(i = 0; i < 2; i++) dtangents(n[i], c[i]);
	dtangents(n[2], c[0]);
	return 0;
}
