#include "hbg.h"
#include <math.h>

typedef struct pointin2d {
    double x, y;
} POINT;

Pl ptpl(double x, double y)
{
	Pl l;
	double d = x * x + y * y + 1;

	l.a = x; l.b = y; l.c = -0.25 * d;
	return l;
}

double limitc(Pl l, double r)
{
	POINT P;
	Pl m;
	double d, x, y, f;

	d = sqrt(l.a * l.a + l.b * l.b);
	P.x = -l.a / d; P.y = -l.b / d;
	x = (1 - r) * P.x; y = (1 - r) * P.y;
	printf("circle %f %f %f\n", x, y, r);
	m = ptpl((1 - 2 * r) * P.x, (1 - 2 * r) * P.y);
	f = l | m / sqrt(- (m | m));
	return f;
}

Pl ctofsm2(Pc c1, Pc c2, int s)
{
	Pl m;
	double e1, f1, n1, n;

	e1 = exp(c1.r);
	if((n =  c1.l | c1.l) > 0) {
		f1 = 0.5 * (e1 + 1. / e1);
		n1 = sqrt(n);
	}
	else {
		f1 = 0.5 * (e1 - 1. / e1);
		n1 = sqrt(-n);;
	}
	m.a = c2.r * c1.l.a + s * n1 * f1 * c2.l.a ;
	m.b = c2.r * c1.l.b + s * n1 * f1 * c2.l.b;
	m.c = c2.r * c1.l.c + s * n1 * f1 * c2.l.c;
	return m;
}

Pl ctofsm0(Pc c1, Pc c2, int s)
{
	Pl m;

	m.a = c2.r * c1.l.a + s * c1.r * c2.l.a ;
	m.b = c2.r * c1.l.b + s * c1.r * c2.l.b;
	m.c = c2.r * c1.l.c + s * c1.r * c2.l.c;
	return m;
}

void dtangents0(Pl l0, Pc c)
{
	double h, ab, ac, bc, A, B, C, AA, rt;
	Pl P;

	h = -c.r * c.r;
	ab = c.l.a * l0.b - l0.a * c.l.b;
	if((l0.b > 0.01) || (l0.b < -0.01)) {
		bc = c.l.b * l0.c - l0.b * c.l.c;
		A = ab * ab + h * (l0.a * l0.a + l0.b * l0.b);
		B = ab * bc - h * l0.a * l0.c;
		C = bc * bc + h * (l0.c * l0.c - 0.25 * l0.b * l0.b);
		rt = sqrt(B * B - A * C), AA = 4 * (-B + rt) / A;
		P.a = AA; P.b = (4 * l0.c - l0.a * AA) / l0.b; P.c = 1.;
		WRITE(P);
		AA = 4 * (-B - rt) / A;
		P.a = AA; P.b = (4 * l0.c - l0.a * AA) / l0.b; P.c = 1.;
		WRITE(P);
	}
	else {
		ac = c.l.a * l0.c - l0.a * c.l.c;
		A = ab * ab + h * (l0.a * l0.a + l0.b * l0.b);
		B = -ab * ac - h * l0.b * l0.c;
		C = ac * ac + h * (l0.c * l0.c - 0.25 * l0.a * l0.a);
		rt = sqrt(B * B - A * C), AA = 4 * (-B + rt) / A;
		P.b = AA; P.a = (4 * l0.c - l0.b * AA) / l0.a; P.c = 1.;
		WRITE(P);
		AA = 4 * (-B - rt) / A;
		P.b = AA; P.a = (4 * l0.c - l0.b * AA) / l0.a; P.c = 1.;
		WRITE(P);
	}
}

int main()
{
	Pl m[4], n[3];
	Pc c[3];
	POINT P[2];
	int i;

	READ(c + 2);
	printf("gray .6\ncircle 0 0 1\n");
	WRITE(c[2].l);
	c[0].l.a = 0.; c[0].l.b = 2.; c[0].l.c = 1; c[0].r = 0.5;
	c[1].l.a = 4.; c[1].l.b = -3.; c[1].l.c = 2.5; c[1].r = 0.25;
	printf("gray 0\n");
	WRITE(c[2]);
	for(i = 0; i < 2; i++) c[i].r = limitc(c[i].l, c[i].r);
	//fprintf(stderr, "%f %f\n", c[0].r, c[1].r);
	printf("color 3 0 0\n");
	for(i = 0; i < 2; i++) {
		WRITE(m[i] = ctofsm2(c[2], c[i], 1));
		WRITE(n[i] = ctofsm2(c[2], c[i], -1));
	}
	WRITE(m[2] = ctofsm0(c[0], c[1], 1));
	WRITE(n[2] = ctofsm0(c[0], c[1], -1));
	printf("color 3 2 0\n");
	WRITE(m[0] * m[1]);
	WRITE(m[0] * n[1]);
	WRITE(n[0] * m[1]);
	WRITE(n[0] * n[1]);
	printf("color 0 3 1\n");
	for(i = 0; i < 2; i++) dtangents(m[i], c[2]);
	dtangents0(m[2], c[0]);
	printf("color 0 1 3\n");
	for(i = 0; i < 2; i++) dtangents(n[i], c[2]);
	dtangents0(n[2], c[0]);
	return 0;
}
