#include "hbg.h"
#include <math.h>

Pl isp(Pc c1, Pc c2, int s)
{
	Pl l;
	double e1, e2, f1, f2, n1, n2;

	e1 = exp(c1.r); e2 = exp(c2.r);
	if((n1 = c1.l | c1.l) > 0) {
		f1 = e1 - 1. / e1;
		n1 = sqrt(n1);
	}
	else {
		f1 = e1 + 1. / e1;
		n1 = sqrt(-n1);
	}
	if((n2 = c2.l | c2.l) > 0) {
		f2 = e2 - 1. / e2;
		n2 = sqrt(n2);
	}
	else {
		f2 = e2 + 1. / e2;
		n2 = sqrt(-n2);
	}
	l.a = f2 * n2 * c1.l.a + s * f1 * n1 * c2.l.a;
	l.b = f2 * n2 * c1.l.b + s * f1 * n1 * c2.l.b;
	l.c = f2 * n2 * c1.l.c + s * f1 * n1 * c2.l.c;
	return l;
}

int main()
{
	Pl m[4], n[3];
	Pc c[4];
	int i;

	for(i = 0; i < 3; i++) READ(c + i);
	c[3] = c[0];
	printf("gray .6\ncircle 0 0 1\n");
	for(i = 0; i < 3; i++) WRITE(c[i].l);
	printf("gray 0\n");
	for(i = 0; i < 3; i++) WRITE(c[i]);
	printf("color 0 0 3\n");
	for(i = 0; i < 3; i++) {
		WRITE(m[i] = isp(c[i], c[i + 1], 1));
		WRITE(n[i] = isp(c[i], c[i + 1], -1));
	}
	m[3] = m[0];
	printf("color 3 0 0\n");
	for(i = 0; i < 3; i++) WRITE(m[i] * m[i + 1]);
	return 0;
}
