#include "hbg.h"
#include <math.h>

double dt(Pl l, Pl m) // [l] と [m] の距離
{
	double l2, m2, lm, d;

	l2 = l | l; m2 = m | m; lm = l | m;
	if(lm < 0) lm *= -1;
	if(l2 < 0) {
		if(m2 < 0) return log((lm + sqrt(lm * lm - l2 * m2)) / (sqrt(l2 * m2)));
		else {
			return log((lm + sqrt(lm * lm - l2 * m2)) / (sqrt(-l2 * m2)));
		}
	}
	else {
		if(m2 < 0) {
			return log((lm + sqrt(lm * lm - l2 * m2)) / (sqrt(-l2 * m2)));
		}
		else {
			if((d = lm * lm - l2 * m2) < 0) return 0.;
			else return log((lm + sqrt(d)) / (sqrt(l2 * m2)));
		}
	}
}
		
int main()
{
    Pl a, b, c, apb, bpc, cpa, amb, bmc, cma, t;
	Pc s;

    READ(&a);
    READ(&b);
    READ(&c);
    normalize(&a);
    normalize(&b);
    normalize(&c);
    printf("gray .6\ncircle 0 0 1\ncolor 0 0 3\n");
    WRITE(a);
    WRITE(b);
    WRITE(c);
    printf("color 0 3 0\n");
    WRITE(a * b);
    WRITE(b * c);
    WRITE(c * a);
    printf("color 3 0 0\n");
    WRITE(apb = a + b);
    WRITE(bpc = b + c);
    WRITE(cpa = c + a);
    WRITE(amb = a - b);
    WRITE(bmc = b - c);
    WRITE(cma = c - a);
    printf("color 3 2 0\n");
    WRITE(apb * bpc);
    WRITE(bpc * cpa);
    WRITE(cpa * apb);
    WRITE(s.l = amb * bmc);
	s.r = dt(a, s.l);
	WRITE(s);
    return 0;
}
