#include "hbg.h"
#include <math.h>

typedef struct pointin2d {
    double x, y;
} POINT;

typedef struct line {
    double a, b, c;
} LINE;

typedef struct circle {
    POINT c;
    double r;
} CIRC;

LINE operator |(POINT p, POINT q)
{
    POINT midpt;
    LINE l;

    midpt.x = (p.x + q.x) / 2.;
    midpt.y = (p.y + q.y) / 2.;
    l.a = p.x - q. x;
    l.b = p.y - q.y;
    l.c = -l.a * midpt.x - l.b * midpt.y;
    return l;
}

POINT operator *(LINE l1, LINE l2)
{
    double d;
    POINT p;

    if((d = l1.a * l2.b - l1.b * l2.a) == 0.) {
		fprintf(stderr, "Error\n");
		exit(0);
    }
    p.x = (l2.c * l1.b - l1.c * l2.b) / d;
    p.y = (l2.a * l1.c - l1.a * l2.c) / d;
    return p;
}

double operator +(POINT p, POINT q)
{
    double x = p.x - q.x, y = p.y - q.y;

    return sqrt(x * x + y * y);
}

POINT pltop(Pl p)
{
	POINT v;
    double d = p | p, a2b2 = p.a * p.a + p.b * p.b, c2 = p.c * p.c, r;

	if(p.c > 0) r = -2. * p.c + sqrt(-d);
	else r = -2. * p.c - sqrt(-d);
	r /= a2b2;
	v.x = p.a * r; v.y = p.b * r;
	return v;
}

int main()
{
    Pl a, b, c, amb, bmc, cma, t;
	POINT u, v, w, z;
	double d;

    READ(&a);
    READ(&b);
    READ(&c);
    normalize(&a);
    normalize(&b);
    normalize(&c);
    printf("gray .6\ncircle 0 0 1\ngray 0\n");
    WRITE(a);
    WRITE(b);
    WRITE(c);
	Pconnect(a, b); Pconnect(b, c); Pconnect(c, a);
	printf("color 0 3 0\n");
	WRITE(amb = a - b); WRITE(bmc = b - c); WRITE(c - a);
	WRITE(amb * bmc);
	u = pltop(a);
	v = pltop(b);
	w = pltop(c);
	z = (u | v) * (v | w);
	d = u + z;
	printf("color 0 0 3\ncircle %f %f %f\n", z.x, z.y, d);
	return 0;
}
