#include "hbg.h"
#include <math.h>

Pl isp(Pc c1, Pc c2, int s)
{
	Pl l;
	double e1, e2, f1, f2, n1, n2;

	e1 = exp(c1.r); e2 = exp(c2.r);
	if((n1 = c1.l | c1.l) > 0) {
		f1 = e1 - 1. / e1;
		n1 = sqrt(n1);
	}
	else {
		f1 = e1 + 1. / e1;
		n1 = sqrt(-n1);
	}
	if((n2 = c2.l | c2.l) > 0) {
		f2 = e2 - 1. / e2;
		n2 = sqrt(n2);
	}
	else {
		f2 = e2 + 1. / e2;
		n2 = sqrt(-n2);
	}
	l.a = f2 * n2 * c1.l.a + s * f1 * n1 * c2.l.a;
	l.b = f2 * n2 * c1.l.b + s * f1 * n1 * c2.l.b;
	l.c = f2 * n2 * c1.l.c + s * f1 * n1 * c2.l.c;
	return l;
}

int main()
{
	Pc c[2];
	int i;

	for(i = 0; i < 2; i++) READ(c + i);
	printf("gray .6\ncircle 0 0 1\n");
	for(i = 0; i < 2; i++) WRITE(c[i].l);
	WRITE(c[0].l * c[1].l);
	printf("gray 0\n");
	for(i = 0; i < 2; i++) WRITE(c[i]);
	printf("color 0 0 3\n");
	WRITE(isp(c[0], c[1], 1));
	WRITE(isp(c[0], c[1], -1));
	return 0;
}
