#include "hbg.h"
#include <math.h>

typedef struct pointin2d {
    double x, y;
} POINT;

void READ(Pl *p)
{
    scanf("%lf%lf%lf", &p->a, &p->b, &p->c);
}

void READ(Pc *c)
{
    scanf("%lf%lf%lf%lf", &c->l.a, &c->l.b, &c->l.c, &c->r);
}

void WRITE(Pl p)
{
    double d = p | p, a2b2 = p.a * p.a + p.b * p.b, c2 = p.c * p.c;

    if(d > 0) {
        double s, t, r;

		if(c2 < a2b2 * .00001) {
			double d = sqrt(a2b2), x0 = p.b / d, y0 = -p.a / d;
			printf("connect %f %f %f %f\n", x0, y0, -x0, -y0);
		}
		else {
			if(p.c > 0) {
				r = .5 * sqrt(d) / p.c;
				t = atan2(p.b, p.a);
			}
			else {
				r = -.5 * sqrt(d) / p.c;
				if((t = atan2(p.b, p.a)) < 0) t += M_PI;
				else t -= M_PI;
			}
			s = atan2(1., r);
			printf("circle %f %f %f %f %f\n", -.5 * p.a / p.c, -.5 * p.b / p.c, r, (t - s) * 64. * 180. / M_PI, s * 128. * 180. / M_PI);
		}
    }
    else {
        double r;

		if(a2b2 < c2 * .000001) printf("disk 0. 0. .02\n");
		else {
			if(p.c > 0) r = -2. * p.c + sqrt(-d);
			else r = -2. * p.c - sqrt(-d);
			r /= a2b2;
			printf("disk %f %f .02\n", p.a * r, p.b * r);
		}
    }
}

POINT pltop(Pl p)
{
	POINT v;
    double d = p | p, a2b2 = p.a * p.a + p.b * p.b, c2 = p.c * p.c, r;

	if(p.c > 0) r = -2. * p.c + sqrt(-d);
	else r = -2. * p.c - sqrt(-d);
	r /= a2b2;
	v.x = p.a * r; v.y = p.b * r;
	return v;
}

void WRITE(Pc c)
{
	double d, a, b, e, g, h, q, r, x0, y0, r0, ip, s, s0;
	POINT P, Q1, Q2;
	Pl P0;

	if((c.l | c.l) < 0.) {
		P = pltop(c.l);
		d = sqrt(P.x * P.x + P.y * P.y);
		e = exp(c.r);
		a = e * (d + 1) / (d - 1);
		b = (a + 1) / (a - 1);
		Q1.x = P.x * b / d; Q1.y = P.y * b / d;
		a = (d + 1) / ((d - 1) * e);
		b = (a + 1) / (a - 1);
		Q2.x = P.x * b / d; Q2.y = P.y * b / d;
		r0 = sqrt((Q1.x - Q2.x) * (Q1.x - Q2.x) + (Q1.y - Q2.y) * (Q1.y - Q2.y)) / 2.;
		x0 = (Q1.x + Q2.x) / 2.; y0 = (Q1.y + Q2.y) / 2.;
		printf("circle %f %f %f\n", x0, y0, r0);
		return;
	}
	//WRITE(c.l);
	P0.a = 4. * c.l.a * c.l.c; P0.b = 4. * c.l.b * c.l.c; P0.c = c.l.a * c.l.a + c.l.b * c.l.b;
	//WRITE(P0);
	P = pltop(P0);
	d = sqrt(P.x * P.x + P.y * P.y);
	e = exp(c.r);
	a = e * (d + 1) / (d - 1);
	b = (a + 1) / (a - 1);
	h = sqrt(c.l.a * c.l.a + c.l.b * c.l.b);
	g = 2 * c.l.c / h;
	if(g < 0) g *= -1;
	q = 0.5 * (1 - b * b) / (g - b);
	x0 = P.x * q / d; y0 = P.y * q / d;
	if((r = q - b) < 0) r *= -1;
	s = 64 * 180 * atan2(-y0, -x0) / M_PI;
	if((r0 = q - g) < 0) r0 *= -1;
	if((q > 0) && (q < g)) s0 = 64 * 180 * ( 1 - acos(r0 / r) / M_PI);
	else s0 = 64 * 180 * acos(r0 / r) / M_PI;
	printf("circle %f %f %f %f %f\n", x0, y0, r, s - s0, 2 * s0);
	a = (d + 1) / ((d - 1) * e);
	b = (a + 1) / (a - 1);
	h = sqrt(c.l.a * c.l.a + c.l.b * c.l.b);
	g = 2 * c.l.c / h;
	if(g < 0) g *= -1;
	q = 0.5 * (1 - b * b) / (g - b);
	x0 = P.x * q / d; y0 = P.y * q / d;
	if((r = q - b) < 0) r *= -1;
	s = 64 * 180 * atan2(-y0, -x0) / M_PI;
	if((r0 = q - g) < 0) r0 *= -1;
	if((q > 0) && (q < g)) s0 = 64 * 180 * ( 1 - acos(r0 / r) / M_PI);
	else s0 = 64 * 180 * acos(r0 / r) / M_PI;
	printf("circle %f %f %f %f %f\n", x0, y0, r, s - s0, 2 * s0);
	return;
}

Pl operator *(Pl p, Pl q)
{
    Pl r;

    r.a = 4. * (p.b * q.c - p.c * q.b);
    r.b = 4. * (p.c * q.a - p.a * q.c);
    r.c = p.b * q.a - p.a * q.b;
    return r;
}

Pl operator *(double t, Pl q)
{
    Pl r;

    r.a = t * q.a;
    r.b = t * q.b;
    r.c = t * q.c;
    return r;
}

Pl operator /(Pl p, double t)
{
    Pl r;

    r.a = p.a / t;
    r.b = p.b / t;
    r.c = p.c / t;
    return r;
}

double operator |(Pl p, Pl q)
{
    return p.a * q.a + p.b * q.b - 4. * p.c * q.c;
}

Pl operator +(Pl l, Pl m)
{
    double l2, m2;
    Pl n;

    /*
    if((l2 = l | l) > 0) l2 = sqrt(l2);
    else l2 = sqrt(-l2);
    if((m2 = m | m) > 0) m2 = sqrt(m2);
    else m2 = sqrt(-m2);
    n.a = l.a / l2 + m.a / m2;
    n.b = l.b / l2 + m.b / m2;
    n.c = l.c / l2 + m.c / m2;
    */
    n.a = l.a + m.a;
    n.b = l.b + m.b;
    n.c = l.c + m.c;
    return n;
}

Pl operator -(Pl l, Pl m)
{
    double l2, m2;
    Pl n;

    /*
    if((l2 = l | l) > 0) l2 = sqrt(l2);
    else l2 = sqrt(-l2);
    if((m2 = m | m) > 0) m2 = sqrt(m2);
    else m2 = sqrt(-m2);
    n.a = l.a / l2 - m.a / m2;
    n.b = l.b / l2 - m.b / m2;
    n.c = l.c / l2 - m.c / m2;
    */
    n.a = l.a - m.a;
    n.b = l.b - m.b;
    n.c = l.c - m.c;
    return n;
}

Pl operator /(Pl l, Pl m)
{
    Pl n;
    double t;
    t = 2. * (l | m) / (m | m);
    n.a = l.a - t * m.a;
    n.b = l.b - t * m.b;
    n.c = l.c - t * m.c;
    return n;
}

void normalize(Pl *l)
{
    double t = (*l) | (*l);

    if((t > -0.001) && (t < 0.001)) return;
    if(t > 0.) t = sqrt(t);
    else {
        t = sqrt(-1. * t);
	if((*l).c < 0.) {
	    (*l).a *= -1.; (*l).b *= -1.; (*l).c *= -1.;
	}
    }
    (*l).a /= t; (*l).b /= t; (*l).c /= t;
    return;
}

Pl normalize2(Pl l)
{
    double t = (l | l);
    Pl m;

    if((t > -0.001) && (t < 0.001)) return l;
    if(t > 0.) t = sqrt(t);
    else {
        t = sqrt(-1. * t);
		if(l.c < 0.) {
			l.a *= -1.; l.b *= -1.; l.c *= -1.;
		}
    }
    m.a = l.a / t; m.b = l.b / t; m.c = l.c / t;
    return m;
}

void Pconnect(Pl P, Pl Q)
{
    double t1, t2, tmp, px, py, qx, qy, lP, lQ, r;
    Pl c;

    if(((lP = P | P) >= 0) || ((lQ = Q | Q) >= 0)) return;
    if((t1 = P.a * P.a + P.b * P.b) < .00001) {
        px = 0.;
        py = 0.;
    }
    else {
        if(P.c < 0) {
	    P.a *= -1.; P.b *= -1.; P.c *= -1.;
	}
        tmp = (-2 * P.c + sqrt(-lP)) / t1;
	px = P.a * tmp;
	py = P.b * tmp;
    } 
    if((t1 = Q.a * Q.a + Q.b * Q.b) < .00001) {
        qx = 0.;
        qy = 0.;
    }
    else {
        if(Q.c < 0) {
	    Q.a *= -1.; Q.b *= -1.; Q.c *= -1.;
	}
        tmp = (-2 * Q.c + sqrt(-lQ)) / t1;
	qx = Q.a * tmp;
	qy = Q.b * tmp;
    } 
    c = P * Q;
    r = .5 * sqrt((c | c) / (c.c * c.c));
    if((c.c == 0.) || (r > 100.)) {
        printf("connect %f %f %f %f\n", px, py, qx, qy);
	return ;
    }
    t1 = atan2(py + .5 * c.b / c.c, px + .5 * c.a / c.c);
    if(t1 < 0.) t1 += 2. * M_PI;
    t2 = atan2(qy + .5 * c.b / c.c, qx + .5 * c.a / c.c);
    if(t2 < 0.) t2 += 2. * M_PI;
    if(t1 > t2) {
        tmp = t1; t1 = t2; t2 = tmp;
    }
    if(t2 < t1 + M_PI) t2 -= t1;
    else {
        tmp = t1; t1 = t2; t2 = 2. * M_PI - t1 + tmp;
    }
    printf("circle %f %f %f %f %f\n", -.5 * c.a / c.c, -.5 * c.b / c.c, r, t1 * 64. * 180. / M_PI, t2 * 64. * 180. / M_PI);
}

void dts(Pl l0, Pl l1, double r)
{
	double e, f, h, ab, ac, bc, A, B, C, AA, rt;
	Pl P;

	e = exp(r);
	if((l1 | l1) < 0) {
		f = 0.5 * (e - 1 / e);
		h = f * f * (l1.a * l1.a + l1.b * l1.b - 4 * l1.c * l1.c);
	}
	else {
		f = 0.5 * (e + 1 / e);
		h = -f * f * (l1.a * l1.a + l1.b * l1.b - 4 * l1.c * l1.c);
	}
    ab = l1.a * l0.b - l0.a * l1.b;
	if((l0.b > 0.01) || (l0.b < -0.01)) {
		bc = l1.b * l0.c - l0.b * l1.c;
		A = ab * ab + h * (l0.a * l0.a + l0.b * l0.b);
		B = ab * bc - h * l0.a * l0.c;
		C = bc * bc + h * (l0.c * l0.c - 0.25 * l0.b * l0.b);
		rt = sqrt(B * B - A * C), AA = 4 * (-B + rt) / A;
		P.a = AA; P.b = (4 * l0.c - l0.a * AA) / l0.b; P.c = 1.;
		WRITE(P);
		//printf("A = %f, B = %f, C = %f, %f %f %f\n", A, B, C, P.a, P.b, P.c);
		AA = 4 * (-B - rt) / A;
		P.a = AA; P.b = (4 * l0.c - l0.a * AA) / l0.b; P.c = 1.;
		WRITE(P);
		//printf("%f %f %f\n", P.a, P.b, P.c);
	}
	else {
		ac = l1.a * l0.c - l0.a * l1.c;
		A = ab * ab + h * (l0.a * l0.a + l0.b * l0.b);
		B = -ab * ac - h * l0.b * l0.c;
		C = ac * ac + h * (l0.c * l0.c - 0.25 * l0.a * l0.a);
		rt = sqrt(B * B - A * C), AA = 4 * (-B + rt) / A;
		P.b = AA; P.a = (4 * l0.c - l0.b * AA) / l0.a; P.c = 1.;
		WRITE(P);
		AA = 4 * (-B - rt) / A;
		P.b = AA; P.a = (4 * l0.c - l0.b * AA) / l0.a; P.c = 1.;
		WRITE(P);
	}
}

void dtangents(Pl l0, Pc c)
{
	dts(l0, c.l, c.r);
	return;
}
