#include "hbg3d.h"
#include <math.h>

Pl pole(Pl l)
{
	Pl m;
	double r = sqrt(l.a * l.a + l.b * l.b + l.c * l.c);

	m.a = l.a / r; m.b = l.b / r; m.c = l.c / r; m.d = 0.5;
	return m;
}

int main(int argc, char *argv[])
{
	Pl p[3], m[3], m2[3], l[3], o;
	int i;
	double s = 0.2, t = 0.1, a[9], b[9], c[9];

	if(argc > 1) s = atof(argv[1]);
	if(argc > 2) t = atof(argv[2]);
	a[0] = a[8] = cos(s);
	a[1] = a[3] = a[5] = a[7] = 0.;
	a[4] = 1.;
	a[6] = sin(s); a[2] = -a[6];
	b[0] = 1.; b[1] = b[2] = b[3] = b[6] = 0.;
	b[4] = b[8] = cos(t);
	b[7] = sin(t); b[5] = -b[7];
	mulp(b, a, c);
	for(i = 0; i < 3; i++) READ(p + i);
	printf("gray .6\ncircle 0 0 1\n");
	o.a = o.b = o.c = 0.; o.d = 1.;
	for(i = 0; i < 3; i++) {
		l[i] = expr(o, p[i], p[(i + 1) % 3]);
		drawP(c, l[i], 0);
		m[i] = pole(p[i] + p[(i + 1) % 3]);
		drawP(c, m[i], 3);
		m[i].d *= -1.;
		drawP(c, m[i], 3);
		m2[i] = pole(p[i] - p[(i + 1) % 3]);
		drawP(c, m2[i], 3);
		m2[i].d *= -1.;
		drawP(c, m2[i], 3);
	}
	for(i = 0; i < 3; i++) drawP(c, expr(o, m[i], m[(i + 1) % 3]), 1);
	drawP(c, expr(o, m2[0], m2[1]), 1);
	return 0;
}

