#include "hbg3d.h"
#include <math.h>

Pl pole(Pl l)
{
	Pl m;
	double r = sqrt(l.a * l.a + l.b * l.b + l.c * l.c);

	m.a = l.a / r; m.b = l.b / r; m.c = l.c / r; m.d = 0.5;
	return m;
}

int main(int argc, char *argv[])
{
	Pl l[3], m[3], n[3], p[3], r, o;
	int i, j;
	double s = 0.2, t = 0.1, a[9], b[9], c[9], u = 0.7, v = sqrt(0.51);

	if(argc > 1) s = atof(argv[1]);
	if(argc > 2) t = atof(argv[2]);
	a[0] = a[8] = cos(s);
	a[1] = a[3] = a[5] = a[7] = 0.;
	a[4] = 1.;
	a[6] = sin(s); a[2] = -a[6];
	b[0] = 1.; b[1] = b[2] = b[3] = b[6] = 0.;
	b[4] = b[8] = cos(t);
	b[7] = sin(t); b[5] = -b[7];
	mulp(b, a, c);
	printf("gray .6\ncircle 0 0 1\n");
	o.a = o.b = o.c = 0.; o.d = 1.;
	r.a = r.b = r.c = 1.; r.d = 0.5;
	for(i = 0; i < 3; i++) {l[i].d = 0.; m[i].d = 0.5;}
	l[0].a = 0.; l[0].b = -0.7; l[0].c = v;
	l[1].a = 0.64; l[1].b = 0.48; l[1].c = 0.6;
	l[2].a = -0.48; l[2].b = 0.64; l[2].c = 0.6;
	m[0].a = 0.; m[0].b = -0.8; m[0].c = -0.6;
	m[1].a = 0.8 * sqrt(0.84); m[1].b = 0.6 * sqrt(0.84); m[1].c = -0.4;
	m[2].a = -0.6 * u; m[2].b = 0.8 * u; m[2].c = -v;
	for(i = 0; i < 3; i++) {
		n[i] = pole(expr(l[i], l[(i + 1) % 3], o));
		p[i] = expr(m[i], m[(i + 1) % 3], o);
		drawP(c, l[i], 3);
		drawP(c, p[i], 2);
	}
	printf("lwidth 2\n");
	for(i = 0; i < 3; i++) {
		drawP(c, expr(l[i], m[i], o), 0);
		drawP(c, expr(n[i], p[i], o), 1);
	}
	//drawP(c, expr(expr(n[0], p[0], o), expr(n[1], p[1], o), o), 1);
	printf("lwidth 3\n");
	//for(i = 0; i < 3; i++) drawsonS(c, l[i], l[(i + 1) % 3], 3);
	for(i = 0; i < 3; i++) drawsonS(c, m[i], m[(i + 1) % 3], 2);
	return 0;
}
