#include "hbg3d.h"
#include <math.h>

typedef struct mnl {
	double c;
	int d[3];
} MNL;

double power(int n, double x)
{
	int i;
	double y = 1.;

	for(i = 0; i < n; i++) y *= x;
	return y;
}

double vofmnl(MNL mo, double x[])
{
	int i;
	double z = mo.c;

	for(i = 0; i < 3; i++) z *= power(mo.d[i], x[i]);
	return z;
}

double vofpol(int l, MNL mo[], double x[])
{
	int i;
	double z = 0.;

	for(i = 0; i < l; i++) z += vofmnl(mo[i], x);
	return z;
}

int main(int argc, char *argv[])
{
	double x[3], z, z0, u, v, cu, su, cv, dv = 0.005;
	double s = 0.3, t = 0.1, a[9], b[9], c[9];
	MNL mo[7];
	PT P, Q;
	Pl m[3];
	int i;

	if(argc > 1) s = atof(argv[1]);
	if(argc > 2) t = atof(argv[2]);
	a[0] = a[8] = cos(s);
	a[1] = a[3] = a[5] = a[7] = 0.;
	a[4] = 1.;
	a[6] = sin(s); a[2] = -a[6];
	b[0] = 1.; b[1] = b[2] = b[3] = b[6] = 0.;
	b[4] = b[8] = cos(t);
	b[7] = sin(t); b[5] = -b[7];
	mulp(b, a, c);
	mo[0].c = 1.; mo[0].d[0] = 2; mo[0].d[1] = 1; mo[0].d[2] = 0;
	mo[1].c = 1.; mo[1].d[0] = 1; mo[1].d[1] = 2; mo[1].d[2] = 0;
	mo[2].c = 1.; mo[2].d[0] = 2; mo[2].d[1] = 0; mo[2].d[2] = 1;
	mo[3].c = 1.; mo[3].d[0] = 1; mo[3].d[1] = 0; mo[3].d[2] = 2;
	mo[4].c = -1.; mo[4].d[0] = 0; mo[4].d[1] = 2; mo[4].d[2] = 1;
	mo[5].c = -1.; mo[5].d[0] = 0; mo[5].d[1] = 1; mo[5].d[2] = 2;
	mo[6].c = -2.; mo[6].d[0] = 1; mo[6].d[1] = 1; mo[6].d[2] = 1;
	for(i = 0; i < 3; i++) m[i].d = 0.;
	m[0].a = m[0].b = 0.; m[0].c = 1.;
	m[1].a = m[1].c = 0.; m[1].b = 1.;
	m[2].a = m[2].b = m[2].c = 1.;
	printf("gray .6\ncircle 0 0 1\ngray 0.\n");
	for(i = 0; i < 3; i++) drawP(c, m[i], 3);
	for(u = 0.; u < 2. * M_PI; u += dv) {
		cu = cos(u); su = sin(u);
		x[0] = cu * 0.001; x[1] = su * 0.001; x[2] = 1.;
		z0 = vofpol(7, mo, x);
		for(v = -0.5 * M_PI + dv; v < 0.5 * M_PI; v += dv) {
			cv = cos(v);
			x[0] = cu * cv;
			x[1] = su * cv;
			x[2] = sin(v);
			z = vofpol(7, mo, x);
			if(z * z0 <= 0.) {
				P.x = x[0], P.y = x[1]; P.z = x[2];
				Q = c * P;
				if(Q.z > 0.) printf("gray 0.\n");
				else printf("gray 0.7\n");
				printf("disk %f %f 0.005\n", Q.x, Q.y);
			}
			z0 = z;
		}
	}
	for(u = 0.; u < 2. * M_PI; u += dv) {
		cu = cos(u); su = sin(u);
		x[1] = cu * 0.001; x[2] = su * 0.001; x[0] = 1.;
		z0 = vofpol(7, mo, x);
		for(v = -0.5 * M_PI + dv; v < 0.5 * M_PI; v += dv) {
			cv = cos(v);
			x[1] = cu * cv;
			x[2] = su * cv;
			x[0] = sin(v);
			z = vofpol(7, mo, x);
			if(z * z0 <= 0.) {
				P.x = x[0], P.y = x[1]; P.z = x[2];
				Q = c * P;
				if(Q.z > 0.) printf("gray 0.\n");
				else printf("gray 0.7\n");
				printf("disk %f %f 0.005\n", Q.x, Q.y);
			}
			z0 = z;
		}
	}
	return 0;
}

