#include "hbg3d.h"
#include <math.h>

#define MAXN 10

int n = 5, adp = 0;
double R, r, c[9];
Pl p[MAXN], q[2], o;

void drawS(double u)
{
	int i;

	printf("copy 0 %d\n", adp);
	for(i = 0; i < n; i++) {
		p[i].a = cos(2 * i * r + u);
		p[i].b = sin(2 * i * r + u);
		p[i].c = 0.; p[i].d = R;
		drawP(c, p[i] / o, 0);
	}
}

int main(int argc, char *argv[])
{
	int i;
	double s = 0.3, t = 0.1, a[9], b[9], u;

	if(argc > 1) {
		n = atoi(argv[1]);
		if((n < 3) || (n > MAXN)) return 0;
	}
	if(argc > 2) s = atof(argv[2]);
	if(argc > 3) t = atof(argv[3]);
	r = M_PI / n;
	R = 0.5 * cos(r);
	a[0] = a[8] = cos(s);
	a[1] = a[3] = a[5] = a[7] = 0.;
	a[4] = 1.;
	a[6] = sin(s); a[2] = -a[6];
	b[0] = 1.; b[1] = b[2] = b[3] = b[6] = 0.;
	b[4] = b[8] = cos(t);
	b[7] = sin(t); b[5] = -b[7];
	mulp(b, a, c);
	o.a = 4.; o.b = 0.; o.c = -6.; o.d = 1.;
	for(i = 0; i < 2; i++) {q[i].a = q[i].b = 0.; q[i].d = 0.5 * cos(0.5 * M_PI - r);}
	q[0].c = 1.; q[1].c = -1.;
	for(i = 0; i < 2; i++) drawP(c, q[i] / o, 3);
	printf("gray .6\ncircle 0 0 1\nactive 1\n");
	adp = 1;
	drawS(0.);
	printf("display 1\npause\n");
	for(u = 0.02, adp = 2; u < M_PI; u += 0.01) {
		printf("active %d\n", adp);
		drawS(u);
		printf("display %d\ntsleep 2\n", adp);
		if(adp == 1) adp = 2;
		else adp = 1;
	}
	return 0;
}
