#include "hbg3d.h"
#include <math.h>

int main(int argc, char *argv[])
{
	Pl p[4], q[4], h[4], o, q2[4], h2[4];
	int i, j;
	double s = 0.2, t = 0.1, a[9], b[9], c[9];

	if(argc > 1) s = atof(argv[1]);
	if(argc > 2) t = atof(argv[2]);
	o.a = o.b = o.c = 0.; o.d = 1.;
	a[0] = a[8] = cos(s);
	a[1] = a[3] = a[5] = a[7] = 0.;
	a[4] = 1.;
	a[6] = sin(s); a[2] = -a[6];
	b[0] = 1.; b[1] = b[2] = b[3] = b[6] = 0.;
	b[4] = b[8] = cos(t);
	b[7] = sin(t); b[5] = -b[7];
	mulp(b, a, c);
	for(i = 0; i < 4; i++) READ(p + i);
	for(i = 0; i < 4; i++) if((p[i] | p[i]) > 0.) return -1;
	printf("gray .6\ncircle 0 0 1\ngray 0.\n");
	for(i = 0; i < 3; i++) {
		for(j = i + 1; j < 4; j++) drawl(c, p[i], p[j]);
	}
	for(i = 0; i < 4; i++) q[i] = expr(p[(i + 1) % 4], p[(i + 2) % 4], p[(i + 3) % 4]);
	printf("color 0 2 3\n");
	for(i = 0; i < 4; i++) {
		h[i] = (q[i] | q[i]) * o - (2 * (q[i] | o)) * q[i];
		normalize(h + i);
		drawl(c, o, h[i]);
		//fprintf(stderr, "%f %f %f %f\n", h[i].a, h[i].b, h[i].c, h[i].d);
	}
	printf("color 0 0 3\n");
	for(i = 0; i < 3; i++) {
		for(j = i + 1; j < 4; j++) drawl(c, h[i], h[j]);
	}
	for(i = 0; i < 4; i++) q2[i] = expr(h[(i + 1) % 4], h[(i + 2) % 4], h[(i + 3) % 4]);
	//for(i = 0; i < 4; i++) drawhfl(c, h[i], o);
	printf("color 3 0 0\n");
	for(i = 0; i < 4; i++) {
		h2[i] = (q2[i] | q2[i]) * p[i] - (q2[i] | p[i]) * q2[i];
		normalize(h2 + i);
		drawl(c, p[i], h2[i]);
		drawhfl(c, h2[i], p[i]);
	}
	return 0;
}
