#include "hbg3d.h"
#include <math.h>

Pl pole(Pl l)
{
	Pl m;
	double r = sqrt(l.a * l.a + l.b * l. b + l.c * l.c);

	m.a = l.a / r; m.b = l.b / r; m.c = l.c / r; m.d = 0.5;
	if(m.c < 0.) m.c *= -1.;
	return m;
}

int main(int argc, char *argv[])
{
	Pl A, P, aa, p, o, Ap, app, ap, App;
	double s = 0.2, t = 0.1, a[9], b[9], c[9], u = 0.7, v = sqrt(0.51);

	A.a = A.b = 0.; A.c = -1.; A.d = 0.5;
	P.a = 0.6; P.b = 0.64; P.c = -0.48; P.d = 0.5;
	aa = A; aa.d = 0.;
	p = P; p.d = 0.;
	o.a = o.b = o.c = 0.; o.d = 1.;
	Ap = expr(o, A, p);
	app = expr(o, Ap, p);
	if(argc > 1) s = atof(argv[1]);
	if(argc > 2) t = atof(argv[2]);
	a[0] = a[8] = cos(s);
	a[1] = a[3] = a[5] = a[7] = 0.;
	a[4] = 1.;
	a[6] = sin(s); a[2] = -a[6];
	b[0] = 1.; b[1] = b[2] = b[3] = b[6] = 0.;
	b[4] = b[8] = cos(t);
	b[7] = sin(t); b[5] = -b[7];
	mulp(b, a, c);
	printf("gray .6\ncircle 0 0 1\n");
	drawP(c, aa, 0); drawP(c, p, 3);
	drawP(c, A, 0); drawP(c, P, 3);
	drawP(c, Ap, 2); drawP(c, ap = pole(Ap), 2);
	ap.d = -0.5; drawP(c, ap, 2);
	drawP(c, app, 1);
	drawP(c, App = pole(app), 1);
	App.d = -0.5;
	drawP(c, App, 1);
	return 0;
}
