#include "hbg3d.h"
#include <math.h>

double e = 0.1, f, g, f2, g2;

double agl(double x, double y, double z)
{
	double x2 = x * x, y2 = y * y, z2 = z * z;
	double g2x2 = g2 * x2, f2y2 = f2 * y2;

	return g2x2 - f2y2 + (g2 - f2) * z2 - e * sqrt((g2x2 + f2y2 + z2) * (g2x2 + f2y2 + z2) - 4 * f2 * g2 * x2 * y2);
}

double agl2(double x, double y, double z)
{
	double x2 = x * x, y2 = y * y, z2 = z * z;
	double g2x2 = g2 * x2, f2y2 = f2 * y2;

	return g2x2 - f2y2 + (g2 - f2) * z2 + e * sqrt((g2x2 + f2y2 + z2) * (g2x2 + f2y2 + z2) - 4 * f2 * g2 * x2 * y2);
}

int main(int argc, char *argv[])
{
	double w, w0, u, v, cu, su, cv, dv = 0.005, x, y, z;
	double s = 0.3, t = 0.1, a[9], b[9], c[9];
	PT Q, R;
	int i, fb = 1;

	if(argc > 1) s = atof(argv[1]);
	if(argc > 2) t = atof(argv[2]);
	if(argc > 3) e = atof(argv[3]);
	if(argc > 4) {
		f = atof(argv[4]);
		g = sqrt(1. - f * f);
	}
	else f = g = 0.5 * sqrt(2.);
	f2 = f * f; g2 = g * g;
	a[0] = a[8] = cos(s);
	a[1] = a[3] = a[5] = a[7] = 0.;
	a[4] = 1.;
	a[6] = sin(s); a[2] = -a[6];
	b[0] = 1.; b[1] = b[2] = b[3] = b[6] = 0.;
	b[4] = b[8] = cos(t);
	b[7] = sin(t); b[5] = -b[7];
	mulp(a, b, c);
	printf("gray .6\ncircle 0 0 1\n");
	printf("color 0 0 3\n");
	for(u = 0.; u < 2. * M_PI; u += dv) {
		cu = cos(u); su = sin(u);
		x = cu * 0.001; y = su * 0.001; z = -1.;
		w0 = agl(x, y, z);
		for(v = -0.5 * M_PI + dv; v < 0.5 * M_PI; v += dv) {
			cv = cos(v);
			x = cu * cv;
			y = su * cv;
			z = sin(v);
			w = agl(x, y, z);
			if(w * w0 < 0.) {
				R.x = -x; R.y = -y; R.z = -z;
				Q = c * R;
				if(fb * Q.z < 0.)  {
					if(fb == 1) printf("color 2 2 3\n");
					else printf("color 0 0 3\n");
					fb *= -1;
				}
				printf("disk %f %f 0.005\n", Q.x, Q.y);
			}
			w0 = w;
		}
	}
	printf("color 0 0 3\n");
	fb = 1;
	for(u = 0.; u < 2. * M_PI; u += dv) {
		cu = cos(u); su = sin(u);
		z = cu * 0.001; x = su * 0.001; y = -1.;
		w0 = agl(x, y, z);
		for(v = -0.5 * M_PI + dv; v < 0.5 * M_PI; v += dv) {
			cv = cos(v);
			z = cu * cv;
			x = su * cv;
			y = sin(v);
			w = agl(x, y, z);
			if(w * w0 < 0.) {
				R.x = -x; R.y = -y; R.z = -z;
				Q = c * R;
				if(fb * Q.z < 0.)  {
					if(fb == 1) printf("color 2 2 3\n");
					else printf("color 0 0 3\n");
					fb *= -1;
				}
				printf("disk %f %f 0.005\n", Q.x, Q.y);
			}
			w0 = w;
		}
	}
	printf("color 3 0 0\n");
	fb = 1;
	for(u = 0.; u < 2. * M_PI; u += dv) {
		cu = cos(u); su = sin(u);
		x = cu * 0.001; y = su * 0.001; z = -1.;
		w0 = agl2(x, y, z);
		for(v = -0.5 * M_PI + dv; v < 0.5 * M_PI; v += dv) {
			cv = cos(v);
			x = cu * cv;
			y = su * cv;
			z = sin(v);
			w = agl2(x, y, z);
			if(w * w0 < 0.) {
				R.x = -x; R.y = -y; R.z = -z;
				Q = c * R;
				if(fb * Q.z < 0.)  {
					if(fb == 1) printf("color 3 2 2\n");
					else printf("color 3 0 0\n");
					fb *= -1;
				}
				printf("disk %f %f 0.005\n", Q.x, Q.y);
			}
			w0 = w;
		}
	}
	printf("gray 0\n");
	R.x = -f; R.y = -g; R.z = 0.;
	Q = c * R;
	printf("disk %f %f 0.01\n", Q.x, Q.y);
	R.x = f;
	Q = c * R;
	printf("disk %f %f 0.01\n", Q.x, Q.y);
	return 0;
}
