#include "hbg3d.h"
#include <math.h>

int m = 3, n = 1;

PT PtonS(double t)
{
	PT R;
	double ct = cos(m * t), st = sin(m * t);

	R.x = ct * cos(n * t);
	R.y = ct * sin(n * t);
	R.z = st;
	return R;
}

int main(int argc, char *argv[])
{
	double u, cu, su, dv = 0.005;
	double s = 0.3, t = 0.1, a[9], b[9], c[9];
	PT Q, R;
	int i, fb = 1, l = 1;

	if(argc > 1) s = atof(argv[1]);
	if(argc > 2) t = atof(argv[2]);
	if(argc > 3) m = atof(argv[3]);
	if(argc > 4) n = atof(argv[4]);
	a[0] = a[8] = cos(s);
	a[1] = a[3] = a[5] = a[7] = 0.;
	a[4] = 1.;
	a[6] = sin(s); a[2] = -a[6];
	b[0] = 1.; b[1] = b[2] = b[3] = b[6] = 0.;
	b[4] = b[8] = cos(t);
	b[7] = sin(t); b[5] = -b[7];
	mulp(a, b, c);
	printf("gray .6\ncircle 0 0 1\n");
	printf("color 0 0 3\n");
	Q = c * PtonS(0.);
	printf("connect %f %f", Q.x, Q.y);
	for(u = dv; u < 2. * M_PI; l++, u += dv) {
		Q = c * PtonS(u);
		if(fb * Q.z < 0.)  {
			if(fb == 1) printf("\ncolor 2 2 3\nconnect");
			else printf("\ncolor 0 0 3\nconnect");
			fb *= -1;
		}
		printf(" %f %f", Q.x, Q.y);
		if((l % 10) == 0) printf("\nconnect %f %f", Q.x, Q.y);
	}
	printf("\n");
	return 0;
}
