#include "hbg3d.h"
#include <math.h>

typedef struct mnl {
	double c;
	int d[3];
} MNL;

double power(int n, double x)
{
	int i;
	double y = 1.;

	for(i = 0; i < n; i++) y *= x;
	return y;
}

double vofmnl(MNL mo, double x[])
{
	int i;
	double z = mo.c;

	for(i = 0; i < 3; i++) z *= power(mo.d[i], x[i]);
	return z;
}

double vofpol(int l, MNL mo[], double x[])
{
	int i;
	double z = 0.;

	for(i = 0; i < l; i++) z += vofmnl(mo[i], x);
	return z;
}

Pl pole(Pl l)
{
	Pl m;
	double r = sqrt(l.a * l.a + l.b * l. b + l.c * l.c);

	m.a = l.a / r; m.b = l.b / r; m.c = l.c / r; m.d = 0.5;
	return m;
}

int main(int argc, char *argv[])
{
	double x[3], z, z0, u, v, cu, su, cv, dv = 0.005;
	double s = 0.3, t = 0.1, a[9], b[9], c[9], r = 0., x0, y0;
	MNL P[4], Q[4];
	PT V, W;
	Pl l, m;
	int i;

	if(argc > 1) s = atof(argv[1]);
	if(argc > 2) t = atof(argv[2]);
	if(argc > 3) r = atof(argv[3]);
	a[0] = a[8] = cos(s);
	a[1] = a[3] = a[5] = a[7] = 0.;
	a[4] = 1.;
	a[6] = sin(s); a[2] = -a[6];
	b[0] = 1.; b[1] = b[2] = b[3] = b[6] = 0.;
	b[4] = b[8] = cos(t);
	b[7] = sin(t); b[5] = -b[7];
	mulp(b, a, c);
	P[0].c = 1.; P[0].d[0] = 2; P[0].d[1] = 0; P[0].d[2] = 0;
	P[1].c = 1.; P[1].d[0] = 1; P[1].d[1] = 1; P[0].d[2] = 0;
	P[2].c = 1.; P[2].d[0] = 0; P[2].d[1] = 2; P[2].d[2] = 0;
	P[3].c = -1.; P[3].d[0] = 0; P[3].d[1] = 0; P[3].d[2] = 2;
	Q[0].c = 1.; Q[0].d[0] = 2; Q[0].d[1] = 0; Q[0].d[2] = 0;
	Q[1].c = -1.; Q[1].d[0] = 1; Q[1].d[1] = 1; Q[1].d[2] = 0;
	Q[2].c = 1.; Q[2].d[0] = 0; Q[2].d[1] = 2; Q[2].d[2] = 0;
	Q[3].c = -0.75; Q[3].d[0] = 0; Q[3].d[1] = 0; Q[3].d[2] = 2;
	printf("gray .6\ncircle 0 0 1\ngray 0.\n");
	for(u = 0.; u < 2. * M_PI; u += dv) {
		cu = cos(u); su = sin(u);
		x[0] = cu * 0.001; x[1] = su * 0.001; x[2] = 1.;
		z0 = vofpol(4, P, x);
		for(v = -0.5 * M_PI + dv; v < 0.5 * M_PI; v += dv) {
			cv = cos(v);
			x[0] = cu * cv;
			x[1] = su * cv;
			x[2] = sin(v);
			z = vofpol(4, P, x);
			if(z * z0 <= 0.) {
				V.x = x[0], V.y = x[1]; V.z = x[2];
				W = c * V;
				if(W.z > 0.) printf("gray 0.\n");
				else printf("gray 0.7\n");
				printf("disk %f %f 0.005\n", W.x, W.y);
			}
			z0 = z;
		}
	}
	/*
	l.a = 1.; l.b = -1.; l.c = -2.; l.d = 0.;
	drawP(c, l, 0);
	drawP(c, pole(l), 1);
	*/
	for(u = 0.; u < 2. * M_PI; u += dv) {
		cu = cos(u); su = sin(u);
		x[0] = cu * 0.001; x[1] = su * 0.001; x[2] = 1.;
		z0 = vofpol(4, Q, x);
		for(v = -0.5 * M_PI + dv; v < 0.5 * M_PI; v += dv) {
			cv = cos(v);
			x[0] = cu * cv;
			x[1] = su * cv;
			x[2] = sin(v);
			z = vofpol(4, Q, x);
			if(z * z0 <= 0.) {
				V.x = x[0], V.y = x[1]; V.z = x[2];
				W = c * V;
				if(W.z > 0.) printf("color 0 0 3\n");
				else printf("color 0 2 3\n");
				printf("disk %f %f 0.005\n", W.x, W.y);
			}
			z0 = z;
		}
	}
	//l.a = 2.; l.b = 1.; l.c = -2.; l.d = 0.;
	x0 = cos(r); y0 = sin(r); l.c = -sqrt(x0 * x0 + x0 * y0 + y0 * y0);
	l.a = x0 + 0.5 * y0; l.b = 0.5 * x0 + y0; l.d = 0.;
	drawP(c, l, 0);
	drawP(c, pole(l), 1);
	return 0;
}
