#include "hbg3d.h"
#include <math.h>

double dif(Pl A, Pl B, Pl P, double d)
{
	return acos((A | P) + 1.) + acos((B | P) + 1.) - d;
}

int main(int argc, char *argv[])
{
	double x[3], z, z0, u, v, cu, su, cv, dv = 0.005, d = 0.6 * M_PI;
	double s = 0.3, t = 0.1, a[9], b[9], c[9];
	Pl A, B, P;
	PT Q, R;
	int i, fb = 1;

	if(argc > 1) s = atof(argv[1]);
	if(argc > 2) t = atof(argv[2]);
	if(argc > 3) d = atof(argv[3]);
	a[0] = a[8] = cos(s);
	a[1] = a[3] = a[5] = a[7] = 0.;
	a[4] = 1.;
	a[6] = sin(s); a[2] = -a[6];
	b[0] = 1.; b[1] = b[2] = b[3] = b[6] = 0.;
	b[4] = b[8] = cos(t);
	b[7] = sin(t); b[5] = -b[7];
	mulp(b, a, c);
	A.a = 0.4; A.b = B.b = 0.; A.c = B.c = -sqrt(0.84); A.d = B.d = 0.5;
	B.a = -0.4;
	printf("gray .6\ncircle 0 0 1\n");
	drawP(c, A, 0); drawP(c, B, 0);
	printf("color 0 0 3\n");
	for(u = 0.; u < 2. * M_PI; u += dv) {
		cu = cos(u); su = sin(u);
		P.a = cu * 0.001; P.b = su * 0.001; P.c = -1.; P.d = 0.5;
		z0 = dif(A, B, P, d);
		for(v = -0.5 * M_PI + dv; v < 0.5 * M_PI; v += dv) {
			cv = cos(v);
			P.a = cu * cv;
			P.b = su * cv;
			P.c = sin(v);
			z = dif(A, B, P, d);
			if(z * z0 < 0.) {
				R.x = -P.a; R.y = -P.b; R.z = -P.c;
				Q = c * R;
				if(fb * Q.z < 0.)  {
					if(fb == 1) printf("color 2 2 3\n");
					else printf("color 0 0 3\n");
					fb *= -1;
				}
				printf("disk %f %f 0.005\n", Q.x, Q.y);
			}
			z0 = z;
		}
	}		
	return 0;
}
