#include "hbg3d.h"
#include <math.h>

double operator |(Pl p, Pl q)
{
	return p.a * q.a + p.b * q.b + p.c * q.c - 4. * p.d * q.d;
}

Pl operator +(Pl p, Pl q)
{
	Pl r;

	r.a = p.a + q.a; r.b = p.b + q.b; r.c = p.c + q.c; r.d = p.d + q.d;
	return r;
}

Pl operator -(Pl p, Pl q)
{
	Pl r;

	r.a = p.a - q.a; r.b = p.b - q.b; r.c = p.c - q.c; r.d = p.d - q.d;
	return r;
}

Pl operator *(double t, Pl p)
{
	Pl r;

	r.a = t * p.a; r.b = t * p.b; r.c = t * p.c; r.d = t * p.d;
	return r;
}

PT operator *(double a[], PT P)
{
	PT Q;

	Q.x = a[0] * P.x + a[1] * P.y + a[2] * P.z;
	Q.y = a[3] * P.x + a[4] * P.y + a[5] * P.z;
	Q.z = a[6] * P.x + a[7] * P.y + a[8] * P.z;
	return Q;
}

Pl operator /(Pl l, Pl m)
{
	double c = (2. * l | m) / (m | m);

	return l - c * m;
}

void mulp(double a[], double b[], double c[])
{
	int i, j, k;

	for(i = 0; i < 3; i++) {
		for(k = 0; k < 3; k++) {
			double s = 0.;
			for(j = 0; j < 3; j++) s += a[i * 3 + j] * b[j * 3 + k];
			c[i * 3 + k] = s;
		}
	}
}

void drawl(double c[], Pl l, Pl m)
{
	PT P = pl2pt(l), Q = pl2pt(m);
	double x = P.x - Q.x, y = P.y - Q.y, z = P.z - Q.z;
	double d = sqrt(x * x + y * y + z * z);

	if(d < 0.1) {
		PT P2 = c * P, Q2 = c * Q;
		printf("connect %f %f %f %f\n", P2.x, P2.y, Q2.x, Q2.y);
	}
	else {
		Pl n = l + m;
		drawl(c, l, n);
		drawl(c, n, m);
	}
}

void READ(Pl *p)
{
    scanf("%lf%lf%lf%lf", &p->a, &p->b, &p->c, &p->d);
}

PT pl2pt(Pl p)
{
	PT v;
    double d = p | p, a2b2c2 = p.a * p.a + p.b * p.b + p.c * p.c, r;

	if(a2b2c2 < 0.001) {
		v.x = v.y = v.z = 0.;
		return v;
	}
	if(p.d > 0) r = -2. * p.d + sqrt(-d);
	else r = -2. * p.d - sqrt(-d);
	r /= a2b2c2;
	v.x = p.a * r; v.y = p.b * r; v.z = p.c * r;
	return v;
}

void normalize(Pl *l)
{
    double t = (*l) | (*l);

    if((t > -0.001) && (t < 0.001)) return;
    if(t > 0.) t = sqrt(t);
    else {
        t = sqrt(-1. * t);
		if((*l).d < 0.) {
			(*l).a *= -1.; (*l).b *= -1.; (*l).c *= -1.; (*l).d *= -1.;
		}
    }
    (*l).a /= t; (*l).b /= t; (*l).c /= t; (*l).d /= t;
    return;
}

double det(double m[])
{
	return m[0] * (m[4] * m[8] - m[5] * m[7]) + m[3] * (m[2] * m[7] - m[1] * m[8]) + m[6] * (m[1] * m[5] - m[2] * m[4]);
}

Pl expr(Pl p, Pl q, Pl r)
{
	Pl s;
	double m[9];

	m[0] = p.a; m[1] = p.b; m[2] = p.c;
	m[3] = q.a; m[4] = q.b; m[5] = q.c;
	m[6] = r.a; m[7] = r.b; m[8] = r.c;
	s.d = det(m);
	m[0] = p.d; m[3] = q.d; m[6] = r.d;
	s.a = 4. * det(m);
	m[1] = p.a; m[4] = q.a; m[7] = r.a;
	s.b = -4. * det(m);
	m[2] = p.b; m[5] = q.b; m[8] = r.b;
	s.c = 4. * det(m);
	return s;
}

void drawhfl(double c[], Pl l, Pl m)
{
	double d;
	Pl n;
	PT A;

	normalize(&l); normalize(&m);
	A = pl2pt(l);
	if(A.x * A.x + A.y * A.y + A.z * A.z > 0.9) return;
	d = l | m;
	n = l + (0.5 / d) * m;
	drawl(c, l, n);
	drawhfl(c, n, l);
}


void drawP(double c[], Pl q, int col)
{
	int i, f;
	char *w[] = {"gray 0.\n", "gray 0.7\n", "color 3 0 0\n", "color 3 3 0\n", "color 0 3 0\n", "color 1 3 2\n", "color 0 0 3\n", "color 1 2 3\n"};
	double u, v, a[9], cu, su, cv, sv, s, t, cs, ss, d, e, q2;
	PT P, Q;

	if((q2 = q | q) < -0.001) return;
	if(q2 < 0.001) {
		P.x = -0.5 * q.a / q.d;
		P.y = -0.5 * q.b / q.d;
		P.z = -0.5 * q.c / q.d;
		Q = c * P;
		if(Q.z > 0.) printf(w[2 * col]);
		else printf(w[2 * col + 1]);
		printf("disk %f %f 0.015\n", Q.x, Q.y);
		return ;
	}
	if(q.d > 0.) d = q.d;
	else d = -q.d;
	if((col < 0) || (col > 3)) col = 0;
	e = sqrt(q.a * q.a + q.b * q.b + q.c * q.c);
	s = acos(2 * d / e);
	if(q.d > 0.) {
		P.x = -q.a / e; P.y = -q.b / e; P.z = -q.c / e;
	}
	else {
		P.x = q.a / e; P.y = q.b / e; P.z = q.c / e;
	}
	Q = c * P;
	//printf("gray .6\ncircle 0 0 1\n");
	cv = Q.z; sv = sqrt(1. - cv * cv);
	u = -atan2(Q.x, Q.y); cu = cos(u); su = sin(u);
	if(Q.x * su * sv < 0.) su *= -1.;
	if(Q.y * cu * sv > 0.) cu *= -1.;
	a[0] = cu; a[1] = -su * cv; a[2] = su * sv;
	a[3] = su; a[4] = cu * cv; a[5] = -cu * sv;
	a[6] = 0.; a[7] = sv; a[8] = cv;
	cs = cos(s); ss = sin(s);
	P.z = cs; P.x = ss; P.y = 0.;
	Q = a * P;
	if(Q.z > 0.) {
		printf(w[2 * col]);
		f = 1;
	}
	else {
		printf(w[2 * col + 1]);
		f = 0;
	}
	printf("connect %f %f ", Q.x, Q.y);
	for(t = 0.1, i = 1; t < 2 * M_PI + 0.1; t += 0.1, i++) {
 		P.x = ss * cos(t); P.y = ss * sin(t);
		Q = a * P;
		printf("%f %f ", Q.x, Q.y);
		if((Q.z > 0.) && (f == 0)) {
			printf("\n%sconnect %f %f ", w[2 * col], Q.x, Q.y);
			f = 1;
		}
		else if((Q.z < 0.) && (f == 1)) {
			printf("\n%sconnect %f %f ", w[2 * col + 1], Q.x, Q.y);
			f = 0;
		}
		else if((i % 5) == 0) printf("\nconnect %f %f ", Q.x, Q.y);
	}
	printf("\n");
}

void drawsonS(double c[], Pl p, Pl q, int col)
{
	int i, f;
	char *w[] = {"gray 0.\n", "gray 0.7\n", "color 3 0 0\n", "color 3 3 0\n", "color 0 3 0\n", "color 1 3 2\n", "color 0 0 3\n", "color 1 2 3\n"};
	double u, v, a[9], cu, su, cv, sv, s, t, cs, ss, d, e, q2, x0, y0, ag, l;
	PT P, Q, P2, Q2;

	ag = acos((p | q) + 1.);
	P.x = -p.a; P.y = -p.b; P.z = -p.c;
	l = sqrt(p.a * p.a + p.b * p.b + p.c * p.c);
	if((l > 1.001) || (l < 0.999)) {
		P.x /= l; P.y /= l; P.z /= l;
	}
	Q.x = -q.a; Q.y = -q.b; Q.z = -q.c;
	l = sqrt(q.a * q.a + q.b * q.b + q.c * q.c);
	if((l > 1.001) || (l < 0.999)) {
		Q.x /= l; Q.y /= l; Q.z /= l;
	}
	P2 = c * P; Q2 = c * Q;
	cv = P2.z; sv = sqrt(1. - cv * cv);
	u = -atan2(P2.x, P2.y); cu = cos(u); su = sin(u);
	if(P2.x * su * sv < 0.) su *= -1.;
	if(P2.y * cu * sv > 0.) cu *= -1.;
	a[0] = cu; a[1] = -su * cv; a[2] = su * sv;
	a[3] = su; a[4] = cu * cv; a[5] = -cu * sv;
	a[6] = 0.; a[7] = sv; a[8] = cv;
	cs = cos(s); ss = sin(s);
	x0 = a[0] * Q2.x + a[3] * Q2.y + a[6] * Q2.z;
	y0 = a[1] * Q2.x + a[4] * Q2.y + a[7] * Q2.z;
	l = sqrt(x0 * x0 + y0 * y0);
	x0 /= l; y0 /= l;
	if(P2.z > 0.) {
		printf(w[2 * col]);
		f = 1;
	}
	else {
		printf(w[2 * col + 1]);
		f = 0;
	}
	printf("connect %f %f ", P2.x, P2.y);
	for(t = 0.05, i = 1; t < ag; t += 0.05, i++) {
		Q.x = sin(t) * x0; Q.y = sin(t) * y0; Q.z = cos(t);
		Q2 = a * Q;
		printf("%f %f ", Q2.x, Q2.y);
		if((Q2.z > 0.) && (f == 0)) {
			printf("\n%sconnect %f %f ", w[2 * col], Q2.x, Q2.y);
			f = 1;
		}
		else if((Q2.z < 0.) && (f == 1)) {
			printf("\n%sconnect %f %f ", w[2 * col + 1], Q2.x, Q2.y);
			f = 0;
		}
		else if((i % 5) == 0) printf("\nconnect %f %f ", Q2.x, Q2.y);
	}
	Q.x = sin(ag) * x0; Q.y = sin(ag) * y0; Q.z = cos(ag);
	Q2 = a * Q;
	printf("%f %f\n", Q2.x, Q2.y);
}
