#include "hbg3d.h"
#include <math.h>

int main(int argc, char *argv[])
{
	Pl p[4], q[4], r[4], u, p2[3];
	PT A;
	int i, j;
	double s = 0.2, t = 0.1, a[9], b[9], c[9], l1l2, l1m, l2m;

	if(argc > 1) s = atof(argv[1]);
	if(argc > 2) t = atof(argv[2]);
	a[0] = a[8] = cos(s);
	a[1] = a[3] = a[5] = a[7] = 0.;
	a[4] = 1.;
	a[6] = sin(s); a[2] = -a[6];
	b[0] = 1.; b[1] = b[2] = b[3] = b[6] = 0.;
	b[4] = b[8] = cos(t);
	b[7] = sin(t); b[5] = -b[7];
	mulp(b, a, c);
	for(i = 0; i < 4; i++) READ(p + i);
	for(i = 0; i < 4; i++) if((p[i] | p[i]) > 0.) return -1;
	printf("gray .6\ncircle 0 0 1\ngray 0.\n");
	for(i = 0; i < 3; i++) {
		for(j = i + 1; j < 4; j++) drawl(c, p[i], p[j]);
	}
	for(i = 0; i < 4; i++) q[i] = expr(p[(i + 1) % 4], p[(i + 2) % 4], p[(i + 3) % 4]);
	//fprintf(stderr, "q : %f %f %f %f\n", q[0].a, q[0].b, q[0].c, q[0].d);
	//fprintf(stderr, "%f %f %f\n", q[0] | p[1], q[0] | p[2], q[0] | p[3]);
	printf("color 0 0 3\n");
	for(i = 0; i < 4; i++) {
		for(j = 0; j < 3; j++) {
			if(j < i) p2[j] = p[j];
			else p2[j] = p[j + 1];
		}
		for(j = 0; j < 3; j++) {
			l1l2 = p2[(j + 1) % 3] | p2[(j + 2) % 3]; l1m = p2[j] | p2[(j + 1) % 3]; l2m = p2[j] | p2[(j + 2) % 3];
			u = (l2m * l1l2 + l1m) * p2[(j + 1) % 3] + (l1m * l1l2 + l2m) * p2[(j + 2) % 3];
			drawl(c, p2[j], u);
		}
	}
	printf("color 3 0 0\n");
	for(i = 0; i < 4; i++) r[i] = (q[i] | q[i]) * p[i] - (q[i] | p[i]) * q[i];
	for(i = 0; i < 4; i++) {
		normalize(r + i);
		A = c * pl2pt(r[i]);
		//printf("disk %f %f 0.01\n", A.x, A.y);
	}
	for(i = 0; i < 4; i++) drawl(c, p[i], r[i]);
	printf("color 3 2 0\n");
	for(i = 0; i < 4; i++) {
		drawhfl(c, p[i], r[i]);
		drawhfl(c, r[i], p[i]);
	}
	return 0;
}
