#include "hbg3d.h"
#include <math.h>

void drawP(double c[], Pl q)
{
	int i, f;
	double u, v, a[9], cu, su, cv, sv, s, t, cs, ss, d, e;
	PT P, Q;

	if(q.d > 0.) d = q.d;
	else d = -q.d;
	e = sqrt(q.a * q.a + q.b * q.b + q.c * q.c);
	s = acos(2 * d / e);
	if(q.d > 0.) {
		P.x = -q.a / e; P.y = -q.b / e; P.z = -q.c / e;
	}
	else {
		P.x = q.a / e; P.y = q.b / e; P.z = q.c / e;
	}
	Q = c * P;
	/*
	if(Q.z > 0.) printf("gray 0.\n");
	else printf("gray 0.5\n");
	printf("disk %f %f 0.02\n", Q.x, Q.y);
	*/
	printf("gray .6\ncircle 0 0 1\ngray 0.\n");
	cv = Q.z; sv = sqrt(1. - cv * cv);
	u = -atan2(Q.x, Q.y); cu = cos(u); su = sin(u);
	//fprintf(stderr, "s = %f, u = %f, %f ?= %f, %f ?= %f\n", s, u, Q.x, su * sv, Q.y, -cu * sv);
	if(Q.x * su * sv < 0.) su *= -1.;
	if(Q.y * cu * sv > 0.) cu *= -1.;
	a[0] = cu; a[1] = -su * cv; a[2] = su * sv;
	a[3] = su; a[4] = cu * cv; a[5] = -cu * sv;
	a[6] = 0.; a[7] = sv; a[8] = cv;
	cs = cos(s); ss = sin(s);
	P.z = cs; P.x = ss; P.y = 0.;
	Q = a * P;
	if(Q.z > 0.) {
		printf("gray 0.\n");
		f = 1;
	}
	else {
		printf("gray 0.7\n");
		f = 0;
	}
	printf("connect %f %f ", Q.x, Q.y);
	for(t = 0.1, i = 1; t < 2 * M_PI + 0.1; t += 0.1, i++) {
 		P.x = ss * cos(t); P.y = ss * sin(t);
		Q = a * P;
		printf("%f %f ", Q.x, Q.y);
		if((Q.z > 0.) && (f == 0)) {
			printf("\ngray 0.\nconnect %f %f ", Q.x, Q.y);
			f = 1;
		}
		else if((Q.z < 0.) && (f == 1)) {
			printf("\ngray 0.7\nconnect %f %f ", Q.x, Q.y);
			f = 0;
		}
		else if((i % 5) == 0) printf("\nconnect %f %f ", Q.x, Q.y);
	}
	printf("\n");
}

int main(int argc, char *argv[])
{
	Pl p[3], q, r, u, ft[3];
	PT A;
	int i, j;
	double s = 0.2, t = 0.1, a[9], b[9], c[9], l1l2, l1m, l2m;

	if(argc > 1) s = atof(argv[1]);
	if(argc > 2) t = atof(argv[2]);
	a[0] = a[8] = cos(s);
	a[1] = a[3] = a[5] = a[7] = 0.;
	a[4] = 1.;
	a[6] = sin(s); a[2] = -a[6];
	b[0] = 1.; b[1] = b[2] = b[3] = b[6] = 0.;
	b[4] = b[8] = cos(t);
	b[7] = sin(t); b[5] = -b[7];
	mulp(b, a, c);
	for(i = 0; i < 3; i++) READ(p + i);
	for(i = 0; i < 3; i++) if((p[i] | p[i]) > 0.) return -1;
	printf("gray .6\ncircle 0 0 1\ngray 0.\n");
	for(i = 0; i < 2; i++) {
		for(j = i + 1; j < 3; j++) {
			drawl(c, p[i], p[j]);
			drawhfl(c, p[i], p[j]);
			drawhfl(c, p[j], p[i]);
		}
	}
	q = expr(p[0], p[1], p[2]);
	drawP(c, q);
	printf("color 0 0 3\n");
	for(i = 0; i < 3; i++) {
		l1l2 = p[(i + 1) % 3] | p[(i + 2) % 3]; l1m = p[i] | p[(i + 1) % 3]; l2m = p[i] | p[(i + 2) % 3];
		u = (l2m * l1l2 + l1m) * p[(i + 1) % 3] + (l1m * l1l2 + l2m) * p[(i + 2) % 3];
		drawl(c, p[i], u);
	}
	u = (p[0] | p[2]) * p[1];
	r = expr(q, u - (p[1] | p[0]) * p[2], u - (p[1] | p[2]) * p[0]);
	normalize(&r);
	A = c * pl2pt(r);
	printf("color 3 0 0\n");
	//printf("disk %f %f 0.02\n", A.x, A.y);
	normalize(&q); normalize(&u);
	if(q.d > 0.) {
		q.a *= -1.; q.b *= -1.; q.c *= -1.; q.d *= -1.;
	}
	u = 0.97 * q + r;
	drawl(c, u, r);
	for(i = 0; i < 3; i++) {
		l1l2 = p[i] | p[(i + 1) % 3], l1m = p[i] | u; l2m = p[(i + 1) % 3] | u;
		drawl(c, u, ft[i] = (l2m * l1l2 + l1m) * p[i] + (l1m * l1l2 + l2m) * p[(i + 1) % 3]);
	}
	printf("color 3 2 0\n");
	drawhfl(c, r, u); drawhfl(c, u, r);
	for(i = 0; i < 3; i++) {
		drawhfl(c, ft[i], u);
		drawhfl(c, u, ft[i]);
	}
	return 0;
}
