#include "hbg3d.h"
#include <math.h>

double ft(PT Q)
{
	/*
	double y2 = Q.y * Q.y;

	return Q.x * Q.x * Q.z - y2 * Q.y;
	*/
	double x2 = Q.x * Q.x, y2 = Q.y * Q.y, z2 = Q.z * Q.z;
	double x2y2, x2y2mz2, x2y2z2, x2my2, x3, xy2;

	x2y2 = x2 + y2;
	x2my2 = x2 - y2;
	x2y2mz2 = x2y2 - z2;
	//x2y2mz2 = x2y2 - 3 * z2;
	x2y2z2 = x2y2 + z2;
	return Q.x * (x2 - 3 * y2) - x2y2 * x2y2;
	//return (3 * x2 - y2) * (3 * x2 - y2) * y2 * x2y2z2 - x2y2 * x2y2 * x2y2 * z2;
	//return x2y2 * x2y2 * (3 * x2y2 - z2) * Q.z - 4 * Q.x * Q.y * (x2 - y2);
	return x2y2 * (5 * x2y2 * x2y2 - 10 * x2y2 * z2 + z2 * z2) * Q.z - 2 * Q.x * Q.y;
	//return x2y2mz2 * x2y2mz2 * x2y2 - x2 * x2y2z2 * x2y2z2;
	//return x2y2z2 * x2y2z2 * Q.y - 4 * x2y2 * x2y2mz2 * Q.z;
	//return x2y2mz2 * x2y2mz2 * x2y2 * x2y2 - x2 * x2y2z2 * x2y2z2 * x2y2z2;
	//return x2my2 * x2my2 * x2y2z2 - x2y2 * x2y2 * x2y2;
	//return 2 * x2y2 * Q.z * (3 * x2y2mz2 * x2y2mz2 - 4 * x2y2 * z2) - Q.y * x2y2z2 * x2y2z2 * x2y2z2;
	//return 8 * (x2y2mz2 * x2y2mz2 - 4 * x2y2 * z2) * x2y2mz2 * x2y2 * Q.z - Q.y * x2y2z2 * x2y2z2 * x2y2z2 * x2y2z2;
	//return 2 * x2y2 * x2y2 * Q.z - (3 * x2 - y2) * x2y2z2 * Q.y;
	return 4 * x2y2 * x2y2 * Q.z * x2y2mz2 - (3 * x2 - y2) * x2y2z2 * x2y2z2 * Q.y;
	//return 2 * x2y2 * x2y2 * x2y2 * Q.z - (5 * x2 * x2 - 10 * x2 * y2 + y2 * y2) * x2y2z2 * Q.y;
	//x3 = x2 * Q.x; xy2 = Q.x * y2;
	//return (x3 - 3 * xy2) * (x3 - 3 * xy2) * x2y2z2 * x2y2z2 - x2y2 * x2y2 * x2y2 * x2y2mz2 * x2y2mz2;
}

int main(int argc, char *argv[])
{
	double z, z0, u, v, cu, su, cv, dv = 0.005;
	double s = 0.3, t = 0.1, a[9], b[9], c[9];
	PT Q, R;
	int i, fb = 1;

	if(argc > 1) s = atof(argv[1]);
	if(argc > 2) t = atof(argv[2]);
	a[0] = a[8] = cos(s);
	a[1] = a[3] = a[5] = a[7] = 0.;
	a[4] = 1.;
	a[6] = sin(s); a[2] = -a[6];
	b[0] = 1.; b[1] = b[2] = b[3] = b[6] = 0.;
	b[4] = b[8] = cos(t);
	b[7] = sin(t); b[5] = -b[7];
	mulp(a, b, c);
	printf("gray .6\ncircle 0 0 1\n");
	printf("color 0 0 3\n");
	for(u = 0.; u < 2. * M_PI; u += dv) {
		cu = cos(u); su = sin(u);
		Q.x = Q.y = 0.; Q.z = -1.;
		z0 = ft(Q);
		for(v = -0.5 * M_PI + dv; v < 0.5 * M_PI; v += dv) {
			cv = cos(v);
			Q.x = cu * cv;
			Q.y = su * cv;
			Q.z = sin(v);
			z = ft(Q);
			if(z * z0 < 0.) {
				R = c * Q;
				if(fb * R.z < 0.)  {
					if(fb == 1) printf("color 2 2 3\n");
					else printf("color 0 0 3\n");
					fb *= -1;
				}
				printf("disk %f %f 0.005\n", R.x, R.y);
			}
			z0 = z;
		}
	}
	return 0;
}
