#include "hbg3d.h"
#include <math.h>

void drawl(Pl l, Pl m)
{
	PT P = pl2pt(l), Q = pl2pt(m);
	double x = P.x - Q.x, y = P.y - Q.y, z = P.z - Q.z;
	double d = sqrt(x * x + y * y + z * z);

	if(d < 0.1) printf("connect %f %f %f %f\n", P.x, P.y, Q.x, Q.y);
	else {
		Pl n = l + m;
		drawl(l, n);
		drawl(n, m);
	}
}

int main()
{
	Pl p, q, p2, q2;
	PT S;
	double c, d;

	READ(&p);
	READ(&q);
	normalize(&p);
	normalize(&q);
	//S = pl2pt(p);
	//fprintf(stderr, "%f\n", p | p);
	if(((p | p) > 0.) || ((q | q) > 0.)) return 0;
	printf("gray .6\ncircle 0 0 1\ngray 0.7\n");
	//printf("disk %f %f 0.02\n", Q.x, Q.y);
	d = p | q;
	c = sqrt(d * d  - 1.);
	p2 = (d + c + 0.001) * p + q; q2 = p + (d + c + 0.001) * q;
	fprintf(stderr, "%f %f\n", p2 | p2, q2 | q2);
	fprintf(stderr, "p2 : %f %f %f %f\nq2 : %f %f %f %f\n", p2.a, p2.b, p2.c, p2.d, q2.a, q2.b, q2.c, q2.d);
	drawl(p2, q2);
	printf("color 3 0 0\n");
	drawl(p, q);
	return 0;
}
