#include "hbg3d.h"
#include <math.h>

int main(int argc, char *argv[])
{
	int i, j, f;
	double u = 0.5, v = 0.3, a[9], cu, su, cv, sv, s, t, cs, ss;
	PT P, Q;

	if(argc > 1) u = atof(argv[1]);
	if(argc > 2) v = atof(argv[2]);
	if(argc > 3) s = atof(argv[3]);
	else s = 0.5;
	printf("gray .6\ncircle 0 0 1\ngray 0.\n");
	cu = cos(u); su = sin(u); cv = cos(v); sv = sin(v);
	a[0] = cu; a[1] = -su * cv; a[2] = su * sv;
	a[3] = su; a[4] = cu * cv; a[5] = -cu * sv;
	a[6] = 0.; a[7] = sv; a[8] = cv;
	cs = cos(s); ss = sin(s);
	P.z = cs; P.x = ss; P.y = 0.;
	Q = a * P;
	if(Q.z > 0.) {
		printf("gray 0.\n");
		f = 1;
	}
	else {
		printf("gray 0.7\n");
		f = 0;
	}
	printf("connect %f %f ", Q.x, Q.y);
	for(t = 0.1, i = 1; t < 2 * M_PI + 0.1; t += 0.1, i++) {
		P.x = ss * cos(t); P.y = ss * sin(t);
		Q = a * P;
		printf("%f %f ", Q.x, Q.y);
		if((Q.z > 0.) && (f == 0)) {
			printf("\ngray 0.\nconnect %f %f ", Q.x, Q.y);
			f = 1;
		}
		else if((Q.z < 0.) && (f == 1)) {
			printf("\ngray 0.7\nconnect %f %f ", Q.x, Q.y);
			f = 0;
		}
		else if((i % 5) == 0) printf("\nconnect %f %f ", Q.x, Q.y);
	}
	printf("\n");
	return 0;
}
