#include "hbg3d.h"
#include <math.h>

void bit(double c[], Pl l1, Pl l2)
{
	Pl m;
	double A, B, C, D, ab, bc, ca, bb, cc;

	ab = l1.a * l2.b - l1.b * l2.a;
	bc = l1.b * l2.c - l1.c * l2.b;
	ca = l1.c * l2.a - l1.a * l2.c;
	bb = l1.b - l2.b;
	cc = l1.c - l2.c;
	A = ab * ab + bc * bc + ca * ca;
	B = ca * cc - ab * bb;
	C = bb * bb + cc * cc - bc * bc;
	D = sqrt(B * B - A * C);
	m.a = (B + D) / A;
	m.b = (ca * m.a - cc) / bc;
	m.c = (ab * m.a + bb) / bc;
	m.d = 0.;
	drawP(c, m, 3);
	m.a = (B - D) / A;
	m.b = (ca * m.a - cc) / bc;
	m.c = (ab * m.a + bb) / bc;
	drawP(c, m, 3);
}

void bit2(double c[], Pl l1, Pl l2)
{
	Pl m;
	double A, B, C, D, ab, bc, ca, bb, cc;

	ab = l1.a * l2.b - l1.b * l2.a;
	bc = l1.b * l2.c - l1.c * l2.b;
	ca = l1.c * l2.a - l1.a * l2.c;
	bb = l1.b + l2.b;
	cc = l1.c + l2.c;
	A = ab * ab + bc * bc + ca * ca;
	B = -ca * cc + ab * bb;
	C = bb * bb + cc * cc - bc * bc;
	D = sqrt(B * B - A * C);
	m.a = (B + D) / A;
	m.b = (ca * m.a + cc) / bc;
	m.c = (ab * m.a - bb) / bc;
	m.d = 0.;
	drawP(c, m, 3);
	m.a = (B - D) / A;
	m.b = (ca * m.a + cc) / bc;
	m.c = (ab * m.a - bb) / bc;
	drawP(c, m, 3);
}

int main(int argc, char *argv[])
{
	Pl p[4], q[3], r, o;
	int i, j;
	double s = 0.2, t = 0.1, a[9], b[9], c[9], u[3];

	if(argc > 1) s = atof(argv[1]);
	if(argc > 2) t = atof(argv[2]);
	a[0] = a[8] = cos(s);
	a[1] = a[3] = a[5] = a[7] = 0.;
	a[4] = 1.;
	a[6] = sin(s); a[2] = -a[6];
	b[0] = 1.; b[1] = b[2] = b[3] = b[6] = 0.;
	b[4] = b[8] = cos(t);
	b[7] = sin(t); b[5] = -b[7];
	mulp(b, a, c);
	printf("gray .6\ncircle 0 0 1\n");
	o.a = o.b = o.c = 0.; o.d = 1.;
	for(i = 0; i < 3; i++) {
		READ(p + i);
		normalize(p + i);
		drawP(c, p[i], 0);
	}
	p[3] = p[0];
	q[0].a = p[0].a - p[1].a;
	q[0].b = p[0].b - p[1].b;
	q[0].c = p[0].c - p[1].c;
	q[0].d = 0.5 * sqrt(q[0].a * q[0].a + q[0].b * q[0].b + q[0].c * q[0].c);
	drawP(c, q[0], 1);
	q[0].d *= -1.;
	drawP(c, q[0], 1);
	for(i = 1; i < 3; i++) {
		q[i].a = p[i].a + p[i + 1].a;
		q[i].b = p[i].b + p[i + 1].b;
		q[i].c = p[i].c + p[i + 1].c;
		q[i].d = 0.5 * sqrt(q[i].a * q[i].a + q[i].b * q[i].b + q[i].c * q[i].c);
		drawP(c, q[i], 1);
		q[i].d *= -1.;
		drawP(c, q[i], 1);
	}
	bit(c, p[0], p[1]);
	bit2(c, p[0], p[2]);
	bit2(c, p[2], p[1]);
	r = expr(q[0], q[1], o);
	drawP(c, r, 1);
	return 0;
}
