#include <stdio.h>
#include <stdlib.h>

typedef struct mnl {
	double c;
	int d[3];
} MNL;

double power(int n, double x)
{
	int i;
	double y = 1.;

	for(i = 0; i < n; i++) y *= x;
	return y;
}

double vofmnl(MNL mo, double x[])
{
	int i;
	double z = mo.c;

	for(i = 0; i < 3; i++) z *= power(mo.d[i], x[i]);
	return z;
}

double vofpol(int l, MNL mo[], double x[])
{
	int i;
	double z = 0.;

	for(i = 0; i < l; i++) z += vofmnl(mo[i], x);
	return z;
}

int main(int argc, char *argv[])
{
	int i;
	MNL mo[5];
	double x[3], z;

	if(argc < 4) return 0;
	for(i = 0; i < 3; i++) x[i] = atof(argv[i + 1]);
	mo[0].c = 1.; mo[0].d[0] = 3; mo[0].d[1] = 0; mo[0].d[2] = 0;
	mo[1].c = -1.; mo[1].d[0] = 1; mo[1].d[1] = 2; mo[1].d[2] = 0;
	mo[2].c = -1.; mo[2].d[0] = 2; mo[2].d[1] = 0; mo[2].d[2] = 1;
	mo[3].c = -2.; mo[3].d[0] = 1; mo[3].d[1] = 0; mo[3].d[2] = 2;
	mo[4].c = 3.; mo[4].d[0] = 0; mo[4].d[1] = 2; mo[4].d[2] = 1;
	//printf("%f * %f^%d * %f^%d * %f^%d = %f\n", mo.c, x[0], mo.d[0], x[1], mo.d[1], x[2], mo.d[2], vofmnl(mo, x));
	printf("%f\n", vofpol(5, mo, x));
	return 0;
}

	
