#!/usr/bin/ruby
# coding: utf-8

def polar(x, y)
  return Math.hypot(y, x), Math.atan2(y, x)
end

def cartesian(mag, angle)
  return mag * Math.cos(angle), mag * Math.sin(angle)
end

raise "引数が二つ必要です。\n" if ARGV.size < 2
x = ARGV[0].to_f
y = ARGV[1].to_f
r, s = polar(x, y)
x2, y2 = cartesian(r, s)
printf "(%f, %f) => (%f, %f) => (%f, %f)\n", x, y, r, s, x2, y2
