#include "spacegeometry.h"
#include <math.h>

#define MAXN 200
#define MAXE 1000

POINT P[MAXN];
Plane h[MAXN];
int f[MAXN], ed[MAXE];
double dst = 3.;

void WRITE(Plane h)
{
	fprintf(stderr, "%fx + %fy + %fz = %f\n", h.a, h.b, h.c, h.d);
}

int alex(int m, Plane h[], Plane g)
{
	int i;

	for(i = 0; i < m; i++) {
		double rt = h[i].d / g.d, e;
		e = h[i].a - rt * g.a;
		if((e > 0.01) || (e < -0.01)) continue;
		e = h[i].b - rt * g.b;
		if((e > 0.01) || (e < -0.01)) continue;
		e = h[i].c - rt * g.c;
		if((e > 0.01) || (e < -0.01)) continue;
		return i;
	}
	return -1;
}

void drawsg(double a[], POINT Q, POINT R)
{
	POINT T;
	double x0, y0, d;

	T = a * Q;
	d = dst / (dst - T.z);
	x0 = T.x * d;
	y0 = T.y * d;
	printf("connect %f %f ", x0, y0);
	T = a * R;
	d = dst / (dst - T.z);
	x0 = T.x * d;
	y0 = T.y * d;
	printf("%f %f\n", x0, y0);
}

int main(int argc, char *argv[])
{
	int i, j, k, l, m = 0, n, e2;
	double s = 0.5, t = 0.1, a[9], b[9], c[9];

	if(argc > 1) n = atoi(argv[1]);
	else n = 4;
	if(argc > 2) s = atof(argv[2]);
	if(argc > 3) t = atof(argv[3]);
	if(argc > 4) dst = atof(argv[4]);
	for(i = 0; i < n; i++) READ(P + i);
	a[0] = a[8] = cos(s);
	a[1] = a[3] = a[5] = a[7] = 0.;
	a[4] = 1.;
	a[6] = sin(s); a[2] = -a[6];
	b[0] = 1.; b[1] = b[2] = b[3] = b[6] = 0.;
	b[4] = b[8] = cos(t);
	b[7] = sin(t); b[5] = -b[7];
	mulp(b, a, c);
	for(i = 0; i < 9; i++) a[i] = c[i];
	for(i = 0; i < n - 2; i++) {
		for(j = i + 1; j < n - 1; j++) {
			for(k = j + 1; k < n; k++) {
				h[m] = pl3pts(P[i], P[j], P[k]);
				if(h[m].d == 0.) continue;
				for(l = 0; l < n; l++) {
					double u = h[m].d - h[m].a * P[l].x - h[m].b * P[l].y - h[m].c * P[l].z;
					if(u < -0.01) break;
				}
				if((l == n) && (alex(m, h, h[m]) < 0)) {
					POINT R, T;
					R.x = h[m].a; R.y = h[m].b; R.z = h[m].c;
					T = a * R;
					if(dst * T.z > 1.) f[m] = 1;
					else f[m] = -1;
					//fprintf(stderr, "%d : ", f[m]);
					//WRITE(h[m]);
					m++;
					if(m >= MAXN) {
						fprintf(stderr, "Too many faces!\n");
						return 0;
					}
				}

			}
		}
	}
	printf("gray 0.7\n");
	for(e2 = i = 0; i < m - 1; i++) {
		for(j = i + 1; j < m; j++) {
			int s = -1;
			for(k = 0; k < n; k++) {
				double u = h[i].d - h[i].a * P[k].x - h[i].b * P[k].y - h[i].c * P[k].z;
				if((u < -0.01) || (u > 0.01)) continue;
				u = h[j].d - h[j].a * P[k].x - h[j].b * P[k].y - h[j].c * P[k].z;
				if((u < -0.01) || (u > 0.01)) continue;
				if(s < 0) s = k;
				else {
					if((f[i] == -1) && (f[j] == -1)) drawsg(a, P[s], P[k]);
					else {
						ed[e2++] = s; ed[e2++] = k;
					}
					break;
				}
			}
		}
	}
	printf("gray 0.\n");
	/*
	for(i = 0; i < m - 1; i++) {
		for(j = i + 1; j < m; j++) {
			int s = -1;
			for(k = 0; k < n; k++) {
				double u = h[i].d - h[i].a * P[k].x - h[i].b * P[k].y - h[i].c * P[k].z;
				if((u < -0.01) || (u > 0.01)) continue;
				u = h[j].d - h[j].a * P[k].x - h[j].b * P[k].y - h[j].c * P[k].z;
				if((u < -0.01) || (u > 0.01)) continue;
				if(s < 0) s = k;
				else {
					if((f[i] == 1) || (f[j] == 1)) drawsg(a, P[s], P[k]);
					break;
				}
			}
		}
	}
	*/
	for(i = 0; i < e2; ) drawsg(a, P[ed[i++]], P[ed[i++]]);
	return 0;
}
