#include "spacegeometry.h"
#include <math.h>

#define MAXN 200
#define MAXE 1000

struct edge {
	int i, j;
	int s, e;
} ed[MAXE];

POINT P[MAXN];
Plane h[MAXN];
int f[MAXN], e2, m = 0, n;
double dst = 3.;

int alex(int m, Plane h[], Plane g)
{
	int i;

	for(i = 0; i < m; i++) {
		double rt = h[i].d / g.d, e;
		e = h[i].a - rt * g.a;
		if((e > 0.01) || (e < -0.01)) continue;
		e = h[i].b - rt * g.b;
		if((e > 0.01) || (e < -0.01)) continue;
		e = h[i].c - rt * g.c;
		if((e > 0.01) || (e < -0.01)) continue;
		return i;
	}
	return -1;
}

void drawsg(double a[], POINT Q, POINT R)
{
	POINT T;
	double x0, y0, d;

	T = a * Q;
	d = dst / (dst - T.z);
	x0 = T.x * d;
	y0 = T.y * d;
	printf("connect %f %f ", x0, y0);
	T = a * R;
	d = dst / (dst - T.z);
	x0 = T.x * d;
	y0 = T.y * d;
	printf("%f %f\n", x0, y0);
}

void drawch(double b[])
{
	int i, j;
	POINT R, T;

	for(i = 0; i < m; i++) {
		R.x = h[i].a; R.y = h[i].b; R.z = h[i].c;
		T = b * R;
		if(dst * T.z > 1.) f[i] = 1;
		else f[i] = -1;
	}
	printf("gray 0.7\n");
	for(i = 0; i < e2; i++) {
		if((f[ed[i].i] == -1) && (f[ed[i].j] == -1)) drawsg(b, P[ed[i].s], P[ed[i].e]);
	}
	printf("gray 0.\n");
	for(i = 0; i < e2; i++) {
		if((f[ed[i].i] == 1) || (f[ed[i].j] == 1)) drawsg(b, P[ed[i].s], P[ed[i].e]);
	}
}


int main(int argc, char *argv[])
{
	int i, j, k, l, dp = 0;
	double s = 0.1, t, a[9], b[9], c[9];

	if(argc > 1) n = atoi(argv[1]);
	else n = 4;
	if(argc > 2) s = atof(argv[2]);
	if(argc > 3) dst = atof(argv[3]);
	for(i = 0; i < n; i++) READ(P + i);
	b[0] = 1.; b[1] = b[2] = b[3] = b[6] = 0.;
	b[4] = b[8] = cos(s);
	b[7] = sin(s); b[5] = -b[7];
	for(i = 0; i < n - 2; i++) {
		for(j = i + 1; j < n - 1; j++) {
			for(k = j + 1; k < n; k++) {
				h[m] = pl3pts(P[i], P[j], P[k]);
				if(h[m].d == 0.) continue;
				for(l = 0; l < n; l++) {
					double u = h[m].d - h[m].a * P[l].x - h[m].b * P[l].y - h[m].c * P[l].z;
					if(u < -0.01) break;
				}
				if((l == n) && (alex(m, h, h[m]) < 0)) {
					m++;
					if(m >= MAXN) {
						fprintf(stderr, "Too many faces!\n");
						return 0;
					}
				}

			}
		}
	}
	for(e2 = i = 0; i < m - 1; i++) {
		for(j = i + 1; j < m; j++) {
			int s = -1;
			for(k = 0; k < n; k++) {
				double u = h[i].d - h[i].a * P[k].x - h[i].b * P[k].y - h[i].c * P[k].z;
				if((u < -0.01) || (u > 0.01)) continue;
				u = h[j].d - h[j].a * P[k].x - h[j].b * P[k].y - h[j].c * P[k].z;
				if((u < -0.01) || (u > 0.01)) continue;
				if(s < 0) s = k;
				else {
					ed[e2].i = i; ed[e2].j = j;
					ed[e2].s = s; ed[e2].e = k;
					e2++;
					break;
				}
			}
		}
	}
	drawch(b);
	printf("pause\n");
	for(dp = 1, t = 0.; t < 2. * M_PI; t += 0.02) {
		printf("active %d\nclear\n", dp);
		c[0] = c[8] = cos(t);
		c[6] = sin(t); c[2] = -c[6]; c[4] = 1.;
		c[1] = c[3] = c[5] = c[7] = 0.;
		mulp(c, b, a);
		drawch(a);
		printf("display %d\ntsleep 10\n", dp);
		if(dp == 0) dp = 1;
		else dp = 0;
	}
	return 0;
}
