#include "spacegeometry.h"
#include <math.h>

#define MAXN 100

POINT P[MAXN];
Plane h[MAXN];

Plane pl3pts(POINT P, POINT Q, POINT R)
{
	double d;
	Plane h;

	d = P.x * Q.y * R.z + P.y * Q.z * R.x + P.z * Q.x * R.y - P.x * Q.z * R.y - P.y * Q.x * R.z - P.z * Q.y * R.x;
	if((d > 0.01) || (d < -0.01)) {
		h.a = Q.y * R.z + P.y * Q.z + P.z * R.y - Q.z * R.y - P.y * R.z - P.z * Q.y;
		h.b = P.x * R.z + Q.z * R.x + P.z * Q.x - P.x * Q.z - Q.x * R.z - P.z * R.x;
		h.c = P.x * Q.y + P.y * R.x + Q.x * R.y - P.x * R.y - P.y * Q.x - Q.y * R.x;
		h.d = 1.;
		h.a /= d; h.b /= d; h.c /= d;
	}
	else {
		h.a = P.y * Q.z - P.z * Q.y;
		h.b = P.z * Q.x - P.x * Q.z;
		h.c = P.x * Q.y - P.y * Q.x;
		h.d = 0.;
	}
	return h;
}

void READ(POINT *p)
{
    scanf("%lf%lf%lf", &p->x, &p->y, &p->z);
    return;
}

int alex(int m, Plane h[], Plane g)
{
	int i;

	for(i = 0; i < m; i++) {
		double rt = h[i].d / g.d, e;
		e = h[i].a - rt * g.a;
		if((e > 0.01) || (e < -0.01)) continue;
		e = h[i].b - rt * g.b;
		if((e > 0.01) || (e < -0.01)) continue;
		e = h[i].c - rt * g.c;
		if((e > 0.01) || (e < -0.01)) continue;
		return i;
	}
	return -1;
}

int main(int argc, char *argv[])
{
	int i, j, k, l, m = 0, n;

	if(argc > 1) n = atoi(argv[1]);
	else n = 4;
	for(i = 0; i < n; i++) READ(P + i);
	for(i = 0; i < n - 2; i++) {
		for(j = i + 1; j < n - 1; j++) {
			for(k = j + 1; k < n; k++) {
				h[m] = pl3pts(P[i], P[j], P[k]);
				if(h[m].d == 0.) continue;
				//WRITE(h[m]);
				for(l = 0; l < n; l++) {
					double u = h[m].d - h[m].a * P[l].x - h[m].b * P[l].y - h[m].c * P[l].z;
					if(u < -0.01) break;
				}
				if((l == n) && (alex(m, h, h[m]) < 0)) {
					printf("%f %f %f\n", h[m].a, h[m].b, h[m].c);
					m++;
				}

			}
		}
	}
	return 0;
}
