#include "spacegeometry.h"
#include <math.h>

void READ(POINT *p)
{
    scanf("%lf%lf%lf", &p->x, &p->y, &p->z);
    return;
}

void READ(Plane *h)
{
    scanf("%lf%lf%lf%lf", &h->a, &h->b, &h->c, &h->d);
    return;
}

void WRITE(POINT P)
{
	printf("(%f, %f, %f)\n", P.x, P.y, P.z);
}

double norm(POINT P)
{
	double d;

	d = P.x * P.x + P.y * P.y + P.z * P.z;
	return sqrt(d);
}

int main(int argc, char *argv[])
{
	POINT P, Q;
	Plane h;
	double l;

	READ(&P);
	READ(&h);
	l = -(h.a * P.x + h.b * P.y + h.c * P.z - h.d) / (h.a * h.a + h.b * h.b + h.c * h.c);
	Q.x = P.x + l * h.a;
	Q.y = P.y + l * h.b;
	Q.z = P.z + l * h.c;
	WRITE(Q);
	printf("%f = %f\n", norm(P - Q), (h.a * P.x + h.b * P.y + h.c * P.z - h.d) / sqrt(h.a * h.a + h.b * h.b + h.c * h.c));
	return 0;
}
