#include "spacegeometry.h"
#include <math.h>

POINT P[50];

void WRITE(POINT P)
{
	printf("%f %f %f\n", P.x, P.y, P.z);
}

int main(int argc, char *argv[])
{
	int i, n;
	double s, t;

	if(argc > 1) n = atoi(argv[1]);
	else n = 6;
	t = M_PI / n;
	s = 0.;
	for(i = 0; i < n; i++) {
		P[i].x = cos(s); P[i].y = sin(s); P[i].z = 0.5;
		s += t;
		P[i + n].x = cos(s); P[i + n].y = sin(s); P[i + n].z = -0.5;
		s += t;
	}
	for(i = 2 * n; i < 3 * n - 1; i++) P[i] = P[i - 2 * n] + P[i - 2 * n + 1] - P[i - n];
	P[3 * n - 1] = P[n - 1] + P[0] - P[2 * n - 1];
	for(i = 3 * n ; i < 4 * n - 1; i++) P[i] = P[i - 2 * n] + P[i - 2 * n + 1] - P[i - 3 * n + 1];
	P[4 * n - 1] = P[2 * n - 1] + P[n] - P[0];
	for(i = 0; i < 4 * n; i++) WRITE(P[i]);
	return 0;
}
