#include "spacegeometry.h"
#include <math.h>

POINT P[36], Q;

void WRITE(POINT P)
{
	printf("%f %f %f\n", P.x, P.y, P.z);
}

int main(int argc, char *argv[])
{
	int i;
	double h;

	if(argc > 1) h = atof(argv[1]);
	else h = 0.4;
	Q.x = Q.z = 0.; Q.y = -1.;
	WRITE(Q);
	for(i = 0; i < 6; i++) {
		P[i].x = cos(i * M_PI / 3.);
		P[i].z = sin(i * M_PI / 3.);
		P[i].y = -h;
		WRITE(P[i]);
	}
	for(i = 0; i < 6; i++) {
		P[i + 6] = P[i] + P[(i + 1) % 6] - Q;
		WRITE(P[i + 6]);
	}
	for(i = 12; i < 18; i++) {
		P[i] = P[i - 6] + P[(i - 5) % 6 + 6] - P[(i - 11) % 6];
		WRITE(P[i]);
	}
	for(i = 18; i < 24; i++) {
		P[i] = P[i - 6] + P[(i - 5) % 6 + 12] - P[(i - 17) % 6 + 6];
		WRITE(P[i]);
	}
	for(i = 24; i < 30; i++) {
		P[i] = P[i - 6] + P[(i - 5) % 6 + 18] - P[(i - 23) % 6 + 12];
		WRITE(P[i]);
	}
	/*	for(i = 30; i < 36; i++) {
		P[i] = P[i - 6] + P[(i - 5) % 6 + 24] - P[(i - 29) % 6 + 18];
		WRITE(P[i]);
	}
	*/
	WRITE(P[24] + P[25] - P[19]);
	return 0;
}
