#include "spacegeometry.h"
#include <math.h>

POINT P[64], Q;

void WRITE(POINT P)
{
	printf("%f %f %f\n", P.x, P.y, P.z);
}

int main(int argc, char *argv[])
{
	int i;
	double h;

	if(argc > 1) h = atof(argv[1]);
	else h = 0.7;
	Q.x = Q.z = 0.; Q.y = -1.;
	WRITE(Q);
	for(i = 0; i < 8; i++) {
		P[i].x = cos(i * M_PI / 4.);
		P[i].z = sin(i * M_PI / 4.);
		P[i].y = -h;
		WRITE(P[i]);
	}
	for(i = 8; i < 16; i++) {
		P[i] = P[i - 8] + P[(i - 7) % 8] - Q;
		WRITE(P[i]);
	}
	for(i = 16; i < 24; i++) {
		P[i] = P[i - 8] + P[(i - 7) % 8 + 8] - P[(i - 15) % 8];
		WRITE(P[i]);
	}
	for(i = 24; i < 32; i++) {
		P[i] = P[i - 8] + P[(i - 15) % 8 + 16] - P[(i - 23) % 8 + 8];
		WRITE(P[i]);
	}
	for(i = 32; i < 40; i++) {
		P[i] = P[i - 8] + P[(i - 23) % 8 + 24] - P[(i - 31) % 8 + 16];
		WRITE(P[i]);
	}
	for(i = 40; i < 48; i++) {
		P[i] = P[i - 8] + P[(i - 31) % 8 + 32] - P[(i - 39) % 8 + 24];
		WRITE(P[i]);
	}
	for(i = 48; i < 56; i++) {
		P[i] = P[i - 8] + P[(i - 39) % 8 + 40] - P[(i - 47) % 8 + 32];
		WRITE(P[i]);
	}
	WRITE(P[48] + P[49] - P[41]);
	return 0;
}
