#include "spacegeometry.h"

void READ(POINT *p)
{
    scanf("%lf%lf%lf", &p->x, &p->y, &p->z);
    return;
}

double operator *(POINT a, POINT b)
{
	return a.x * b.x + a.y * b.y + a.z * b.z;
}

POINT operator -(POINT a, POINT b)
{
	POINT c;

	c.x = a.x - b.x;
	c.y = a.y - b.y;
	c.z = a.z - b.z;
	return c;
}

POINT operator +(POINT a, POINT b)
{
	POINT c;

	c.x = a.x + b.x;
	c.y = a.y + b.y;
	c.z = a.z + b.z;
	return c;
}

POINT operator *(double r, POINT a)
{
	POINT b;

	b.x = r * a.x;
	b.y = r * a.y;
	b.z = r * a.z;
	return b;
}

Plane operator |(POINT a, POINT b)
{
	Plane h;

	h.a = a.x - b.x;
	h.b = a.y - b.y;
	h.c = a.z - b.z;
	h.d = (a.x * a.x + a.y * a.y + a.z * a.z - b.x * b.x - b.y * b.y - b.z * b.z) / 2.;
	return h;
}

POINT operator *(double a[], POINT P)
{
	POINT Q;

	Q.x = a[0] * P.x + a[1] * P.y + a[2] * P.z;
	Q.y = a[3] * P.x + a[4] * P.y + a[5] * P.z;
	Q.z = a[6] * P.x + a[7] * P.y + a[8] * P.z;
	return Q;
}

void drawpolygon(double a[], POINT v[], int p[], int n, double dst)
{
	int i;
	POINT Q;
	double x0, y0, d;

	Q = a * v[p[0]];
	d = dst / (dst - Q.z);
	x0 = Q.x * d;
	y0 = Q.y * d;
	printf("connect %f %f ", x0, y0);
	for(i = 1; i < n; i++) {
		Q = a * v[p[i]];
		d = dst / (dst - Q.z);
		printf("%f %f ", Q.x * d, Q.y * d);
	}
	printf("%f %f\n", x0, y0);

}

void mulp(double a[], double b[], double c[])
{
	int i, j, k;

	for(i = 0; i < 3; i++) {
		for(k = 0; k < 3; k++) {
			double s = 0.;
			for(j = 0; j < 3; j++) s += a[i * 3 + j] * b[j * 3 + k];
			c[i * 3 + k] = s;
		}
	}
}

void WRITE(double a[], POINT P, POINT Q)
{
	POINT S, T;

	S = a * P; T = a * Q;
	printf("connect %f %f %f %f \n", S.x, S.y, T.x, T.y);
	return;
}

SEG sgorth2l(LINE l, LINE m)
{
	SEG s;
	double a1, a2, b1, b2, c, d, t, u;

	a1 = (l.P.x - m.P.x) * l.V.x + (l.P.y - m.P.y) * l.V.y + (l.P.z - m.P.z) * l.V.z;
	a2 = (l.P.x - m.P.x) * m.V.x + (l.P.y - m.P.y) * m.V.y + (l.P.z - m.P.z) * m.V.z;
	b1 = l.V.x * l.V.x + l.V.y * l.V.y + l.V.z * l.V.z;
	b2 = m.V.x * m.V.x + m.V.y * m.V.y + m.V.z * m.V.z;
	c = l.V.x * m.V.x + l.V.y * m.V.y + l.V.z * m.V.z;
	d = c * c - b1 * b2;
	t = (a1 * c - a2 * b1) / d; u = (a1 * b2 - a2 * c) / d;
	s.P = l.P + u * l.V;
	s.Q = m.P + t * m.V;
	return s;
}

void WRITE(double a[], LINE l)
{
	POINT P, V;

	P = a * l.P;
	V = a * l.V;
	printf("line %f %f %f\n", V.y, -V.x, P.y * V.x - P.x * V.y);
	return;
}

void WRITE(double a[], SEG s)
{
	POINT S, T;

	S = a * s.P; T = a * s.Q;
	printf("connect %f %f %f %f \n", S.x, S.y, T.x, T.y);
	return;
}

Plane pl3pts(POINT P, POINT Q, POINT R)
{
	double d;
	Plane h;

	d = P.x * Q.y * R.z + P.y * Q.z * R.x + P.z * Q.x * R.y - P.x * Q.z * R.y - P.y * Q.x * R.z - P.z * Q.y * R.x;
	if((d > 0.01) || (d < -0.01)) {
		h.a = Q.y * R.z + P.y * Q.z + P.z * R.y - Q.z * R.y - P.y * R.z - P.z * Q.y;
		h.b = P.x * R.z + Q.z * R.x + P.z * Q.x - P.x * Q.z - Q.x * R.z - P.z * R.x;
		h.c = P.x * Q.y + P.y * R.x + Q.x * R.y - P.x * R.y - P.y * Q.x - Q.y * R.x;
		h.d = 1.;
		h.a /= d; h.b /= d; h.c /= d;
	}
	else {
		h.a = P.y * Q.z - P.z * Q.y;
		h.b = P.z * Q.x - P.x * Q.z;
		h.c = P.x * Q.y - P.y * Q.x;
		h.d = 0.;
	}
	return h;
}
