#include "spacegeometry.h"
#include <math.h>

POINT v[48];

void drawoct(double a[], POINT v[])
{
	int i;
	POINT Q;
	double x0, y0;

	Q = a * v[0];
	x0 = Q.x;
	y0 = Q.y;
	printf("connect %f %f ", x0, y0);
	for(i = 1; i < 8; i++) {
		Q = a * v[i];
		printf("%f %f ", Q.x, Q.y);
	}
	printf("%f %f\n", x0, y0);

}

void drawsg(double a[], POINT P, POINT Q)
{
	POINT R;

	R = a * P;
	printf("connect %f %f ", R.x, R.y);
	R = a * Q;
	printf("%f %f\n", R.x, R.y);
}

void mulp(double a[], double b[], double c[])
{
	int i, j, k;

	for(i = 0; i < 3; i++) {
		for(k = 0; k < 3; k++) {
			double s = 0.;
			for(j = 0; j < 3; j++) s += a[i * 3 + j] * b[j * 3 + k];
			c[i * 3 + k] = s;
		}
	}
}

int main(int argc, char *argv[])
{
	double a[9], b[9], c[9];
	POINT P, Q;
	double s = 0.5, t = 0.1, sq2 = sqrt(2.);
	int i;

	if(argc > 1) s = atof(argv[1]);
	if(argc > 2) t = atof(argv[2]);
	a[0] = a[8] = cos(s);
	a[1] = a[3] = a[5] = a[7] = 0.;
	a[4] = 1.;
	a[6] = sin(s); a[2] = -a[6];
	b[0] = 1.; b[1] = b[2] = b[3] = b[6] = 0.;
	b[4] = b[8] = cos(t);
	b[7] = sin(t); b[5] = -b[7];
	mulp(a, b, c);
	for(i = 0; i < 9; i++) a[i] = c[i];
	v[0].x = v[7].x = (3. + sq2) / 7.; v[0].y = v[3].y = (2 * sq2 - 1.) / 7.;
	v[1].x = v[6].x = v[0].y; v[1].y = v[2].y = v[0].x;
	v[2].x = v[5].x = -v[1].x;
	v[3].x = v[4].x = -v[0].x;
	v[4].y = v[7].y = -v[0].y;
	v[5].y = v[6].y = -v[1].y;
	for(i = 0; i < 8; i++) {
		v[i].z = v[i + 8].x = v[i + 16].y = 1.;
		v[i + 8].y = v[i + 16].z = v[i + 24].y = v[i + 32].y = v[i + 40].z = v[i].y;
		v[i + 8].z = v[i + 16].x = v[i + 24].x = v[i + 32].z = v[i + 40].x = v[i].x;
		v[i + 24].z = v[i + 32].x = v[i + 40].y = -1.;
	}
	printf("gray 0.7\n");
	drawoct(a, v + 24);
	drawoct(a, v + 32);
	drawoct(a, v + 40);
	drawsg(a, v[24], v[11]);
	drawsg(a, v[31], v[12]);
	drawsg(a, v[26], v[21]);
	drawsg(a, v[34], v[20]);
	drawsg(a, v[27], v[35]);
	drawsg(a, v[28], v[36]);
	drawsg(a, v[3], v[32]);
	drawsg(a, v[4], v[39]);
	drawsg(a, v[29], v[45]);
	drawsg(a, v[30], v[46]);
	drawsg(a, v[37], v[44]);
	drawsg(a, v[38], v[43]);
	printf("gray 0.\n");
	drawoct(a, v);
	drawoct(a, v + 8);
	drawoct(a, v + 16);
	drawsg(a, v[0], v[8]);
	drawsg(a, v[7], v[15]);
	drawsg(a, v[1], v[17]);
	drawsg(a, v[2], v[18]);
	drawsg(a, v[9], v[16]);
	drawsg(a, v[10], v[23]);
	drawsg(a, v[6], v[41]);
	drawsg(a, v[5], v[42]);
	drawsg(a, v[14], v[40]);
	drawsg(a, v[13], v[47]);
	drawsg(a, v[25], v[22]);
	drawsg(a, v[42], v[41]);
	drawsg(a, v[40], v[41]);
	drawsg(a, v[40], v[47]);
	drawsg(a, v[24], v[25]);
	drawsg(a, v[32], v[33]);
	drawsg(a, v[33], v[19]);
	return 0;
}
