#include "spacegeometry.h"
#include <math.h>

/*
typedef struct edge {
	int s, e;
} EDG;
EDG e[28];
*/

POINT v[48];
int p[] = {0, 1, 17, 16, 9, 8, 2, 3, 32, 33, 19, 18, 4, 5, 42, 43, 38, 39, 6, 7, 15, 14, 40, 41, 24, 25, 22, 23, 10, 11, 26, 27, 35, 34, 20, 21, 28, 29, 45, 44, 37, 36, 30, 31, 12, 13, 47, 46},
	p3[] = {0, 8, 15, 7, 24, 11, 12, 31, 27, 35, 36, 28, 3, 32, 39, 4, 1, 2, 18, 17, 25, 26, 21, 22, 29, 30, 46, 45, 5, 6, 41, 42, 9, 10, 23, 16, 19, 20, 34, 33, 37, 38, 43, 44, 13, 14, 40, 47};

void drawoct(double a[], POINT v[])
{
	int i;
	POINT Q;
	double x0, y0, d;

	Q = a * v[0];
	d = 1. / (3. - Q.z);
	x0 = Q.x * d;
	y0 = Q.y * d;
	printf("connect %f %f ", x0, y0);
	for(i = 1; i < 8; i++) {
		Q = a * v[i];
		d = 1. / (3. - Q.z);
		printf("%f %f ", Q.x * d, Q.y * d);
	}
	printf("%f %f\n", x0, y0);

}

void drawhex(double a[], POINT v[], int p[])
{
	int i;
	POINT Q;
	double x0, y0, d;

	Q = a * v[p[0]];
	d = 1. / (3. - Q.z);
	x0 = Q.x * d;
	y0 = Q.y * d;
	printf("connect %f %f ", x0, y0);
	for(i = 1; i < 6; i++) {
		Q = a * v[p[i]];
		d = 1. / (3. - Q.z);
		printf("%f %f ", Q.x * d, Q.y * d);
	}
	printf("%f %f\n", x0, y0);

}

void drawrec(double a[], POINT v[], int p[])
{
	int i;
	POINT Q;
	double x0, y0, d;

	Q = a * v[p[0]];
	d = 1. / (3. - Q.z);
	x0 = Q.x * d;
	y0 = Q.y * d;
	printf("connect %f %f ", x0, y0);
	for(i = 1; i < 4; i++) {
		Q = a * v[p[i]];
		d = 1. / (3. - Q.z);
		printf("%f %f ", Q.x * d, Q.y * d);
	}
	printf("%f %f\n", x0, y0);

}

void drawsg(double a[], POINT P, POINT Q)
{
	POINT R;
	double d;

	R = a * P;
	d = 1. / (3. - R.z);
	printf("connect %f %f ", R.x * d, R.y * d);
	R = a * Q;
	d = 1. / (3. - R.z);
	printf("%f %f\n", R.x * d, R.y * d);
}

void mulp(double a[], double b[], double c[])
{
	int i, j, k;

	for(i = 0; i < 3; i++) {
		for(k = 0; k < 3; k++) {
			double s = 0.;
			for(j = 0; j < 3; j++) s += a[i * 3 + j] * b[j * 3 + k];
			c[i * 3 + k] = s;
		}
	}
}

int main(int argc, char *argv[])
{
	double a[9], b[9], c[9];
	POINT dr[6], dr2[8], dr3[12];
	double s = 0.5, t = 0.1, sq2 = sqrt(2.);
	int i, j;

	if(argc > 1) s = atof(argv[1]);
	if(argc > 2) t = atof(argv[2]);
	for(i = 0; i < 6; i++) dr[i].x = dr[i].y = dr[i].z = 0.;
	dr[0].z = dr[1].x = dr[2].y = 1.;
	dr[3].z = dr[4].x = dr[5].y = -1.;
	for(i = 0; i < 4; i++) dr2[i].z = 1.;
	for( ; i < 8; i++) dr2[i].z = -1.;
	dr2[0].y = dr2[1].y = dr2[4].y = dr2[5].y = 1.;
	dr2[2].y = dr2[3].y = dr2[6].y = dr2[7].y = -1.;
	dr2[0].x = dr2[3].x = dr2[4].x = dr2[7].x = 1.;
	dr2[1].x = dr2[2].x = dr2[5].x = dr2[6].x = -1.;
	for(i = 0; i < 4; i++) dr3[i].y = 0;
	for( ; i < 8; i++) dr3[i].x = 0;
	for( ; i < 12; i++) dr3[i].z = 0;
	dr3[0].x = dr3[1].x = dr3[8].x = dr3[11].x = 1.;
	dr3[2].x = dr3[3].x = dr3[9].x = dr3[10].x = -1.;
	dr3[4].y = dr3[5].y = dr3[8].y = dr3[9].y = 1.;
	dr3[6].y = dr3[7].y = dr3[10].y = dr3[11].y = -1.;
	dr3[0].z = dr3[3].z = dr3[4].z = dr3[7].z = 1.;
	dr3[1].z = dr3[2].z = dr3[5].z = dr3[6].z = -1.;
	a[0] = a[8] = cos(s);
	a[1] = a[3] = a[5] = a[7] = 0.;
	a[4] = 1.;
	a[6] = sin(s); a[2] = -a[6];
	b[0] = 1.; b[1] = b[2] = b[3] = b[6] = 0.;
	b[4] = b[8] = cos(t);
	b[7] = sin(t); b[5] = -b[7];
	mulp(b, a, c);
	for(i = 0; i < 9; i++) a[i] = c[i];
	v[0].x = v[7].x = (3. + sq2) / 7.; v[0].y = v[3].y = (2 * sq2 - 1.) / 7.;
	v[1].x = v[6].x = v[0].y; v[1].y = v[2].y = v[0].x;
	v[2].x = v[5].x = -v[1].x;
	v[3].x = v[4].x = -v[0].x;
	v[4].y = v[7].y = -v[0].y;
	v[5].y = v[6].y = -v[1].y;
	for(i = 0; i < 8; i++) {
		v[i].z = v[i + 8].x = v[i + 16].y = 1.;
		v[i + 8].y = v[i + 16].z = v[i + 24].y = v[i + 32].y = v[i + 40].z = v[i].y;
		v[i + 8].z = v[i + 16].x = v[i + 24].x = v[i + 32].z = v[i + 40].x = v[i].x;
		v[i + 24].z = v[i + 32].x = v[i + 40].y = -1.;
	}
	/*
	e[0].s = 11; e[0].e = 24; e[1].s = 21; e[1].e = 26; e[2].s = 20; e[2].e = 34;
	e[4].s = 12; e[4].e = 31; e[5].s = 27; e[5].e = 35; e[6].s = 28; e[6].e = 36;
	e[7].s = 3; e[7].e = 32; e[8].s = 4; e[8].e = 39; e[9].s = 29; e[9].e = 45;
	e[10].s = 14; e[10].e = 40; e[11].s = 30; e[11].e = 46; e[12].s = 37; e[12].e = 44;
	e[13].s = 13; e[13].e = 47; e[14].s = 38; e[14].e = 43; e[15].s = 0; e[15].e = 8;
	e[16].s = 7; e[16].e = 15; e[17].s = 1; e[17].e = 17; e[18].s = 2; e[18].e = 18;
	e[3].s = 9; e[3].e = 16; e[19].s = 10; e[19].e = 23; e[20].s = 6; e[20].e = 41;
	e[21].s = 5; e[21].e = 42; e[22].s = 14; e[22].e = 40; e[23].s = 13; e[23].e = 47;
	e[24].s = 5; e[24].e = 42; e[25].s = 25; e[25].e = 22; e[26].s = 40; e[26].e = 47;
	e[27].s = 33; e[27].e = 19;
	*/
	printf("gray 0.7\n");
	//for(i = 0; i < 28; i++) drawsg(a, v[e[i].s], v[e[i].e]);
	for(i = 0; i < 6; i++) drawoct(a, v + 8 * i);
	for(i = 0; i < 8; i++) drawhex(a, v, p + i * 6);
	printf("gray 0\n");
	for(i = 0; i < 6; i++) {
		if((a * dr[i]) * dr[0] > 0.33) drawoct(a, v + 8 * i);
	}
	for(i = 0; i < 8; i++) {
		if((a * dr2[i]) * dr[0] > 0.33 * sqrt(3.)) drawhex(a, v, p + i * 6);
	}
	for(i = 0; i < 12; i++) {
		if((a * dr3[i]) * dr[0] > 0.33 * sq2) drawrec(a, v, p3 + i * 4);
	}
	return 0;
}
