#include "spacegeometry.h"
#include <math.h>

int main(int argc, char *argv[])
{
	double s = 0.2, t = 0.1, a[9], b[9], c[9];
	POINT A, B, C, D;
	LINE ab, ac, ad, bc, bd, cd;

	if(argc > 1) s = atof(argv[1]);
	if(argc > 2) t = atof(argv[2]);
	a[0] = a[8] = cos(s);
	a[1] = a[3] = a[5] = a[7] = 0.;
	a[4] = 1.;
	a[6] = sin(s); a[2] = -a[6];
	b[0] = 1.; b[1] = b[2] = b[3] = b[6] = 0.;
	b[4] = b[8] = cos(t);
	b[7] = sin(t); b[5] = -b[7];
	mulp(b, a, c);
	READ(&A); READ(&B); READ(&C); READ(&D);
	WRITE(c, A, B); WRITE(c, A, C); WRITE(c, A, D);
	WRITE(c, B, C); WRITE(c, B, D); WRITE(c, C, D);
	printf("color 0 0 3\n");
	ab.P = A; ab.V.x = B.x - A.x; ab.V.y = B.y - A.y; ab.V.z = B.z - A.z;
	cd.P = C; cd.V.x = D.x - C.x; cd.V.y = D.y - C.y; cd.V.z = D.z - C.z;
	WRITE(c, sgorth2l(ab, cd));
	ac.P = A; ac.V.x = C.x - A.x; ac.V.y = C.y - A.y; ac.V.z = C.z - A.z;
	bd.P = B; bd.V.x = D.x - B.x; bd.V.y = D.y - B.y; bd.V.z = D.z - B.z;
	WRITE(c, sgorth2l(ac, bd));
	ad.P = A; ad.V.x = D.x - A.x; ad.V.y = D.y - A.y; ad.V.z = D.z - A.z;
	bc.P = B; bc.V.x = C.x - B.x; bc.V.y = C.y - B.y; bc.V.z = C.z - B.z;
	WRITE(c, sgorth2l(ad, bc));
	return 0;
}
