#include "spacegeometry.h"

void READ(POINT *p)
{
    scanf("%lf%lf%lf", &p->x, &p->y, &p->z);
    return;
}

void WRITE(POINT P)
{
	printf("(%f, %f, %f)\n", P.x, P.y, P.z);
}

Plane pl3pts(POINT P, POINT Q, POINT R)
{
	double d;
	Plane h;

	d = P.x * Q.y * R.z + P.y * Q.z * R.x + P.z * Q.x * R.y - P.x * Q.z * R.y - P.y * Q.x * R.z - P.z * Q.y * R.x;
	if((d > 0.1) || (d < -0.1)) {
		h.a = Q.y * R.z + P.y * Q.z + P.z * R.y - Q.z * R.y - P.y * R.z - P.z * Q.y;
		h.b = P.x * R.z + Q.z * R.x + P.z * Q.x - P.x * Q.z - Q.x * R.z - P.z * R.x;
		h.c = P.x * Q.y + P.y * R.x + Q.x * R.y - P.x * R.y - P.y * Q.x - Q.y * R.x;
		h.d = d;
	}
	else {
		h.a = P.y * Q.z - P.z * Q.y;
		h.b = P.z * Q.x - P.x * Q.z;
		h.c = P.x * Q.y - P.y * Q.x;
		h.d = 0.;
	}
	return h;
}

int main(int argc, char *argv[])
{
	int i, n;
	POINT P[3];
	Plane h;

	/*
	if(argc > 1) n = atoi(argv[1]);
	else n = 1;
	*/
	for(i = 0; i < 3; i++) READ(P + i);
	h = pl3pts(P[0], P[1], P[2]);
	printf("%fx + %fy + %fz = %f\n", h.a, h.b, h.c, h.d);
	return 0;
}
